#include <stdio.h>

#define MAX_LEN 100

char replacement[MAX_LEN+1];

void do_match(FILE *in, FILE *out, char *start, char *match)
{
    char c; int i;

    if (*match == 0) {
	for(i=0; start<match; start++, i++) fputc(replacement[i], out);
	return;
    }

    c = fgetc(in);
    if (c == EOF  && feof(in)) {
	for(; start<match; start++) fputc(*start, out);
	fputc(c, out);
	return;
    }
    if (c == *match) {
	do_match(in, out, start, match+1);
    } else { /* failed, output normal characters */
	for(; start<match; start++) fputc(*start, out);
	fputc(c, out);
    }
}


int main(int argc, char **argv)
{
    FILE *in, *out;
    char c, *match;
    int rep_length, match_length;

    if (argc != 5) {
	fprintf(stderr, "Usage: rename <infile> <outfile> <from> <to>\n");
	exit(1);
    }
    in = fopen(argv[1], "r");
    if (in == NULL) {
	fprintf(stderr, "Unable to open input file \"%s\".\n", argv[1]);
	exit(2);
    }
    out = fopen(argv[2], "w");
    if (out == NULL) {
	fprintf(stderr, "Unable to open output file \"%s\".\n", argv[2]);
	exit(3);
    }
    rep_length = strlen(argv[4]);
    if (rep_length > MAX_LEN) {
	fprintf(stderr, "Replacement string too long.\n");
	exit(4);
    }
    strcpy(replacement, argv[4]);

    match = argv[3];
    match_length = strlen(match);

    if (rep_length > match_length) {
	fprintf(stderr,
      "Warning: replacement longer than match string -- truncating.\n");
    } else if (match_length > rep_length) {
	fprintf(stderr,
     "Warning: replacement shorter than match string -- padding with zero.\n");
    }
	
    for (;;) {
	c = fgetc(in);
	if (c == EOF)
	  if (feof(in)) break;
	if (c == *match)
	  do_match(in, out, match, match+1);
	else
	  fputc(c, out);
    }
    fclose(out);
    fclose(in);
    return(0);
}
