
#include "cprep.h"
#include "symtable.h"

#define START_IPI            100
#define MAX_IPI              255


void ipi_statement(Lex *name, Lex *code, Lex *handler)
{
    Symbol *iptr = newsymbol();
    int ipicode;
    
    iptr->text = name->text;
    iptr->class = ID_USERIPI;
    if ( (ipicode = atoi(TEXT(code->text))) >= START_IPI &&
        ipicode <= MAX_IPI) {
	iptr->attributes = ipicode;
	
	insert_symbol(iptr, currtree);
	
	fprintf(fipic, "ipi %s %d %s\n", 
		TEXT(name->text), ipicode, TEXT(handler->text));
	/*
	  fprintf(fipic,"{void  %s(); intr_handler[%d] = (FuncPtr)%s;}\n",
	  TEXT(handler->text),
	  ipicode,
	  TEXT(handler->text));
	  */
    }
    else
      error("user defined ipis can have codes between %d and %d",
	    START_IPI, MAX_IPI);
    free_chain(code->text);
    free_chain(handler->text);
}
