/* YACC parser for C syntax.
   Copyright (C) 1987, 1988, 1989 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* To whomever it may concern: I have heard that such a thing was once
written by AT&T, but I have never seen it.  */


/* These are the 8 conflicts you should get in parse.output;
   the state numbers may vary if minor changes in the grammar are made.

State 41 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
State 92 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
State 99 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
State 103 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
State 119 contains 1 shift/reduce conflict.  (See comment at component_decl.)
State 183 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
State 193 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
State 199 contains 1 shift/reduce conflict.  (Two ways to recover from error.)
*/

%{

#include <string.h>
#include "cprep.h"
#include "symtable.h"

extern int lineno;

#ifndef errno
extern int errno;
#endif

void yyerror ();

/* Cause the `yydebug' variable to be defined.  */
#define YYDEBUG 1
%}

%start program


/* All identifiers that are not reserved words
   and are not declared typedefs in the current block */
%token IDENTIFIER

/* All identifiers that are declared typedefs in the current block.
   In some contexts, they are treated just like IDENTIFIER,
   but they can also serve as typespecs in declarations.  */
%token TYPENAME

/* Reserved words that specify storage class.
   yylval contains an IDENTIFIER_NODE which indicates which one.  */
%token SCSPEC

/* Reserved words that specify type.
   yylval contains an IDENTIFIER_NODE which indicates which one.  */
%token TYPESPEC

/* Reserved words that qualify type: "const" or "volatile".
   yylval contains an IDENTIFIER_NODE which indicates which one.  */
%token TYPE_QUAL

/* Character or numeric constants.
   yylval is the node for the constant.  */
%token CONSTANT
%token CHARCONSTANT

/* String constants in raw form.
   yylval is a STRING_CST node.  */
%token STRING

/* "...", used for functions with variable arglists.  */
%token ELLIPSIS

/* the reserved words */
%token SIZEOF ENUM STRUCT UNION IF ELSE WHILE DO FOR SWITCH CASE DEFAULT
%token BREAK CONTINUE RETURN GOTO ASM TYPEOF ALIGNOF
%token ATTRIBUTE
%token TAG IPI PLACEAT

/* Add precedence rules to solve dangling else s/r conflict */
%nonassoc IF
%nonassoc ELSE

/* Define the operator tokens and their precedences.
   The value is an integer because, if used, it is the tree code
   to use in the expression made from the operator.  */

%right  ASSIGN '='
%right  '?' ':'
%left  OROR
%left  ANDAND
%left  '|'
%left  '^'
%left  '&'
%left  EQCOMPARE
%left  ARITHCOMPARE
%left  LSHIFT RSHIFT
%left  '+' '-'
%left  '*' '/' '%'
%right  UNARY PLUSPLUS MINUSMINUS
%left HYPERUNARY
%right MYPOINTERPREC
%left  POINTSAT SHPOINTSAT '.' '(' '['



%{

int undeclared_variable_notice;	/* 1 if we explained undeclared var errors.  */

extern int yylex();

%}

%%
program: /* empty */

	| extdefs

	;

/* the reason for the strange actions in this rule
 is so that notype_initdecls when reached via datadef
 can find a valid list of type and sc specs in $0. */

extdefs:
	extdef

	| extdefs reset_flags extdef

	;

extdef:
	fndef

	| datadef

        | ipidef
	;

datadef:
          declmods outmods setspecs notype_initdecls ';'
            { 
	      out1( &$5 );
	      if ( SAVEPARMS_FLAG )
		poplevel_tree();
	    }

	| typed_declspecs setspecs initdecls ';'
            { 
	      out1( &$4 ); 
	      if ( SAVEPARMS_FLAG )
		poplevel_tree();
	    }

        | declmods outmods ';'
            { out1( &$3 ); }

	| typed_declspecs ';'
            { /* printf("datadef\n"); */
              out1( &$2 ); }

	| error ';'
            { 
	      if ( SAVEPARMS_FLAG )
		poplevel_tree();
	    }

	| error '}'
            { 
	      if ( SAVEPARMS_FLAG )
		poplevel_tree();
	    }

	| ';'

	;

fndef:
	  typed_declspecs setspecs declarator

	  prexdecls xdecls 

	  compstmt_or_error

	| typed_declspecs setspecs declarator error

	| declmods outmods setspecs notype_declarator

	  prexdecls xdecls

	  compstmt_or_error

	| declmods outmods setspecs notype_declarator error

	| setspecs notype_declarator

	  prexdecls xdecls

	  compstmt_or_error

	| setspecs notype_declarator error

	;


ipidef:
        IPI identifier CONSTANT identifier ';'
          { 
	    ipi_statement( &$2, &$3, &$4 );
	    free_chain($1.text);
	    free_chain($5.text);
	  }
        ;

identifier:
	IDENTIFIER
          { $$ = $1; }
/*
	| TYPENAME
          {  
	    error("typedef used where identifier is required");
	    $$ = $1;
	  } 
*/
	;

unop:     '&'
           { $$.tinfo = AMPERSAND_UNARY; }

	| '-'
           { $$.tinfo = MINUS_UNARY; }

	| '+'
           { $$.tinfo = PLUS_UNARY; }

	| PLUSPLUS
           { $$.tinfo = PLUSPLUS_UNARY; }

	| MINUSMINUS
           { $$.tinfo = MINUSMINUS_UNARY; }

	| '~'
           { $$.tinfo = NEGATE_UNARY; }

	| '!'
           { $$.tinfo = NOT_UNARY; }

	;

expr:	nonnull_exprlist
           { $$ = $1; }
	;

exprlist:
	  /* empty */
           { $$ = empty_lex(); }

	| nonnull_exprlist
           { $$ = $1; }
	;

nonnull_exprlist:
	expr_no_commas
           { $$ = $1; }

	| nonnull_exprlist ',' expr_no_commas
           {
	     $3.text = ((Expr *)$3.tinfo)->val =
	       link_chain3( $1.text, $2.text, $3.text);
	     $$ = $3;
	   }
	;

unary_expr:
	primary
           { $$ = $1; }

        | '@' cast_expr   %prec UNARY
           {
	     unary_at(&$1, (Expr *)($2.tinfo));
	     $$ = $2;
	   }

	| '*' cast_expr   %prec UNARY
           {
	     unary_star(&$1, (Expr *)($2.tinfo));
	     $$ = $2;
	   }

	| unop cast_expr  %prec UNARY
           {
	     unary_op(&$1, &$2 );
	     $$ = $2;
	   }

	| SIZEOF unary_expr  %prec UNARY
           {
	     unary_sizeof(&$1, (Expr *)($2.tinfo));
	     $$ = $2;
	   }

	| SIZEOF '(' typename ')'  %prec HYPERUNARY
           {
	     unary_sizeof_typename(&$1, &$2, &$3, &$4);
	     $$ = $1;
	   }

        | TAG unary_expr %prec UNARY
           {
	     unary_tag(&$1, (Expr *)($2.tinfo));
	     $$ = $2;
	   }

	;

cast_expr:
	unary_expr
           { $$ = $1; }

	| '(' typename ')' cast_expr  %prec UNARY
           {
	     Expr *expr = (Expr *)$4.tinfo;

	     expr->val = link_chain4($1.text, $2.text, $3.text, 
				     parenthesize(expr->val));
	     expr->type = (Type *)$2.tinfo;
	     $$ = $4;
	   }
	;

expr_no_commas:
	  cast_expr
           {
	     $1.text = ((Expr *)$1.tinfo)->val;
	     $$ = $1;
	   }

	| expr_no_commas '+' expr_no_commas
           {
	     make_binary_expression( PLUS_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas '-' expr_no_commas
           {
	     make_binary_expression( MINUS_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas '*' expr_no_commas
           {
	     make_binary_expression( MULT_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas '/' expr_no_commas
           {
	     make_binary_expression( TRUNC_DIV_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas '%' expr_no_commas
           {
	     make_binary_expression( TRUNC_MOD_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas LSHIFT expr_no_commas
           {
	     make_binary_expression( LSHIFT_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas RSHIFT expr_no_commas
           {
	     make_binary_expression( RSHIFT_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas ARITHCOMPARE expr_no_commas
           {
	     make_binary_expression( $2.tinfo, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas EQCOMPARE expr_no_commas
           {
	     make_binary_expression( $2.tinfo, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas '&' expr_no_commas
           {
	     make_binary_expression( BIT_AND_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas '|' expr_no_commas
           {
	     make_binary_expression( BIT_IOR_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }

	| expr_no_commas '^' expr_no_commas
           {
	     make_binary_expression( BIT_XOR_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }
	
	| expr_no_commas ANDAND expr_no_commas
           {
	     make_binary_expression( AND_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }
		
	| expr_no_commas OROR expr_no_commas
           {
	     make_binary_expression( OR_EXPR, &$1, &$2, &$3, FREEYES );
	     $$ = $1;
	   }
		
	| expr_no_commas '?' xexpr ':' expr_no_commas
           {
	     make_conditional_expression( &$1, &$2, &$3, &$4, &$5 );
	     $$ = $1;
	   }
		
	| expr_no_commas '=' expr_no_commas
           {
	     make_assignment( &$1, &$2, &$3, 0 );
	     $$ = $1;
	   }

	| expr_no_commas ASSIGN expr_no_commas
           {
	     make_abbreviated_assignment( &$1, &$2, &$3, 0 );
	     $$ = $1;
	   }
	;

primary:
	IDENTIFIER
           {
	     primary_ident( &$1 );
	     $$ = $1;
	   }

	| CONSTANT
           { 
	     primary_const( &$1 );
	     $$ = $1;
	   }

        | CHARCONSTANT
           {
	     primary_const( &$1 );
	     $$ = $1;
	   }

	| STRING
	   { 
	     primary_string( &$1 );
	     $$ = $1;
	   }

	| '(' expr ')'
           {
	     ((Expr *)$2.tinfo)->val = link_chain3($1.text,
						   $2.text,
						   $3.text);
	     $$ = $2;
	   }
		
	| '(' error ')'
		
	| primary '(' exprlist ')'   %prec '.'
           {
	     primary_func( (Expr *)($1.tinfo), &$2, &$3, &$4 );
	     $$ = $1;
	   }
		
	    

	| primary '[' expr ']'   %prec '.'
           {
	     primary_array( (Expr *)($1.tinfo), &$2, (Expr *)($3.tinfo), &$4 );
	     $$ = $1;
	   }
		
	| primary '.' identifier
           {
	     primary_compound( (Expr *)($1.tinfo), &$2, &$3 );
	     $$ = $1;
	   }

	| primary POINTSAT identifier
           {
	     primary_pointsat( (Expr *)($1.tinfo), &$2, &$3 );
	     $$ = $1;
	   }

        | primary SHPOINTSAT identifier
           {
	     primary_shared_pointsat( (Expr *)($1.tinfo), &$2, &$3 );
	     $$ = $1;
	   }

	| primary PLUSPLUS
           {
	     $2.tinfo = PLUSPLUS_UNARY;
	     make_increment_decrement( &$1, &$2, POST );
	     $$ = $1;
	   }
	| primary MINUSMINUS
	   {
	     $2.tinfo = MINUSMINUS_UNARY;
	     make_increment_decrement( &$1, &$2, POST );
	     $$ = $1;
	   }
	;



prexdecls:   
          { 
	    out1( &$0 );
	    insert_symbol( (Symbol *)$0.tinfo, TREEOF($0) );
	    xdecls_flag = TRUE;
	  }
        ;



xdecls:
	/* empty */
          { xdecls_flag = FALSE; }

	| decls
          { xdecls_flag = FALSE; }

	;

decls:
	decl
	| errstmt
	| decls  decl
	| decl errstmt
	;

reset_flags:
          {
	    if ( SAVEPARMS_FLAG )
	      poplevel_tree();
		
	    reset_decl();

	    xdecls_flag = FALSE;
	  }
        ;

/* records the type and storage class specs to use for processing
   the declarators that follow.
   Maintains a stack of outer-level values of current_declspecs,
   for the sake of parm declarations nested in function declarators.  */


outmods:  /* empty */
           {       
	      if (!SHARED_FLAG)
		out1( &$0 );
	      else 
		free_chain($0.text);

	      currdecl->type->typequals = currdecl->typequals;
	    }


setspecs: /* empty */
            {
	      if ( SHARED_FLAG )
		{
		  if ( currdecl->attributes & RID_STATIC )
		    error("static shared declarations are not allowed");
		  else
		    if ( currdecl->attributes & RID_EXTERN )
		      outs("extern");
		  outs("__SHARED__");
		}
	    }
	;


setspecs2: /* empty */
            {
	      if ( SHARED_FLAG )
		{
		  if ( currdecl->attributes & RID_STATIC )
		    error("static shared declarations are not allowed");
		  else
		    if ( currdecl->attributes & RID_EXTERN )
		      outs("extern");
		    else 
		      error("only extern shared declarations are allowed inside statements");
		  outs("__SHARED__");
		}
	    }
	;


/* This is only called from inside statements. Can only define extern and
 * static shared variables -- maybe define a setspecs2 to impose those 
 * restrictions.
 */

decl: 
	typed_declspecs setspecs2 initdecls ';'
            { 
	      out1( &$4 );
	      reset_decl();
	      if ( !xdecls_flag && SAVEPARMS_FLAG )
		poplevel_tree();
	    }
		  
	| declmods outmods setspecs2 notype_initdecls ';'
            {
	      out1( &$5 );
	      reset_decl();
	      if ( !xdecls_flag && SAVEPARMS_FLAG )
		poplevel_tree();
	    }
		  
	| typed_declspecs ';'
            { /* printf("decl\n"); */
	      out1( &$2 );
	      reset_decl();	    
	    }
		
	| declmods outmods ';'
            {
	      out1( &$3 );
	      reset_decl();
	    }
	;

/* Declspecs which contain at least one type specifier or typedef name.
   (Just `const' or `volatile' is not enough.)
   A typedef'd name following these is taken as a name to be declared.  */

typed_declspecs:
	  typespec 

	| declmods outmods typespec
	;


/* List of just storage classes and type modifiers.
   A declaration can start with just this, but then it cannot be used
   to redeclare a typedef-name.  */

declmods:
	  TYPE_QUAL
               { new_typequal( &$1 ); $$ = $1; }

	| SCSPEC
               { new_scspec( &$1 ); $$ = $1; }

	| declmods TYPE_QUAL
               { add_typequal( &$1, &$2 ); $$ = $1; }

	| declmods SCSPEC
               { add_scspec( &$1, &$2 ); $$ = $1; }

	;


/* Used instead of declspecs where storage classes are not allowed
   (that is, for typenames and structure components).
   Don't accept a typedef-name if anything but a modifier precedes it.  */

typed_typespecs:

	  typespec2 
             { $$ = $1; }
		
	| nonempty_type_quals typespec2 
             {
	       $2.text = link_chain2( $1.text, $2.text );
	       $$ = $2;
	     }
	;


/* A typespec (but not a type qualifier).
   Once we have seen one of these in a declaration,
   if a typedef name appears then it is being redeclared.  */



typespec: TYPESPEC
            {
	      free_type(currdecl->type);
	      currdecl->type = (Type *)$1.tinfo;
	      currdecl->type->typequals = currdecl->typequals;

	      if ( !SHARED_FLAG )
		out1( &$1 );
	      else 
		free_chain($1.text);
	    }

	| structsp
            {
		/* printf("%s:%d:typespec-structsp\n", input_filename, lineno); */
	      if ( $1.tinfo != NULL ) {
		free_type(currdecl->type);
		currdecl->type = ((Symbol *)$1.tinfo)->type;
		currdecl->type->typequals = currdecl->typequals;
	      }
	      out1( &$1 );
	      if ( last_string_nonempty && SHARED_FLAG )
		{ outs(";"), outnl(); }
	    }


	| TYPENAME
            {
	      Symbol *symbol = (Symbol *)$1.tinfo;

	      free_type(currdecl->type);
	      currdecl->type = symbol->type;
	      /* Typequals are taken from typedef */

	      if ( !SHARED_FLAG )
		out1( &$1 );
	      else {
		outnl();
		free_chain($1.text);
	      }
	    }
	;



typespec2: TYPESPEC
            {
	      free_type(currdecl->type);
	      currdecl->type = (Type *)$1.tinfo;
	      currdecl->type->typequals = currdecl->typequals;

	      $$ = $1;
	    }

	| structsp
            {
	      /* printf("%s:%d:typespec2-structsp\n", input_filename, lineno); */
	      if ( $1.tinfo != NULL ) {
		free_type(currdecl->type);
		currdecl->type = ((Symbol *)$1.tinfo)->type;
		currdecl->type->typequals = currdecl->typequals;
	      }
	      $$ = $1;
	    }

	| TYPENAME
            {
	      Symbol *symbol = (Symbol *)$1.tinfo;

	      free_type(currdecl->type);
	      currdecl->type = symbol->type;
	      /* Typequals are taken from typedef */
	      /* printf("typespec2(%d) = %d, symbol 0x%x, level=%d\n",
		     lineno, TID(currdecl->type), symbol, symbol->type->level);
	      print_chain(symbol->text);
	      print_chain(symbol->type->text); */
	      $$ = $1;
	    }
	;



initdecls:
	initdcl
          {
	    if ( !xdecls_flag && SAVEPARMS_FLAG )
	      poplevel_tree();

	    if ( SHARED_FLAG )
	      {
		outid( &$1 );
		if ( !(currdecl->attributes & RID_EXTERN) )
		  outgetmem( &$1 );
		free_chain($1.text);
	      }
	    else
	      out1( &$1 );

	    insert_symbol( (Symbol *)$1.tinfo, TREEOF($1) );

	  }

	| initdecls ',' initdcl
          {
	    if ( !xdecls_flag && SAVEPARMS_FLAG )
	      poplevel_tree();

	    if ( SHARED_FLAG )
	      {
		out1( &$2 ); outid( &$3 );
		if ( !(currdecl->attributes & RID_EXTERN) )
		  outgetmem( &$3 );
		free_chain($3.text);
	      }
	    else
	      out2( &$2, &$3 );
	    
	    insert_symbol( (Symbol *)$3.tinfo, TREEOF($3) );

	  }

	;


notype_initdecls:
	notype_initdcl
          {
	    if ( !xdecls_flag && SAVEPARMS_FLAG )
	      poplevel_tree();

	    if ( SHARED_FLAG )
	      {
		outid( &$1 );
		if ( !(currdecl->attributes & RID_EXTERN) )
		  outgetmem( &$1 );
		free_chain($1.text);
	      }
	    else
	      out1( &$1 );

	    insert_symbol( (Symbol *)$1.tinfo, TREEOF($1) );

	  }

	| notype_initdecls ',' initdcl
          {
	    if ( !xdecls_flag && SAVEPARMS_FLAG )
	      poplevel_tree();

	    if ( SHARED_FLAG )
	      {
		out1( &$2 ); outid( &$3 );
		if ( !(currdecl->attributes & RID_EXTERN) )
		  outgetmem( &$3 );
		free_chain($3.text);
	      }
	    else
	      out2( &$2, &$3 );
	    
	    insert_symbol( (Symbol *)$3.tinfo, TREEOF($3) );

	  }

	;



initdcl:
	  declarator '=' init

	    { 
		if ( SHARED_FLAG )
		  {
		    warning("initialization of shared variable attempted -- ignored");
		    free_chain($2.text); free_chain($3.text);
		  }
		else 
		  $1.text = link_chain3( $1.text, $2.text, $3.text );
		$$ = $1;
	    }

	| declarator 
            { $$ = $1; }
		  
	| declarator PLACEAT CONSTANT

	  {
	    if ( ! SHARED_FLAG )
	      {
		warning("placement directive for nonshared variable -- ignored");
		free_chain($2.text); free_chain($3.text);
	      }
	    else
	      {
		placement_directive( &$1 , &$3 );
		free_chain($2.text); free_chain($3.text);
	      }
	    $$ = $1;
	  }
	      
	;


notype_initdcl:
	  notype_declarator '=' init
  
            { 
	      if ( SHARED_FLAG )
		{
		  warning("initialization of shared variable attempted -- ignored");
		  free_chain($2.text); free_chain($3.text);
		}
	      else 
		$1.text = link_chain3( $1.text, $2.text, $3.text );
	      $$ = $1;
	    }

	| notype_declarator 
            { $$ = $1; }
		  
		  
	| notype_declarator PLACEAT CONSTANT

	  {
	    if ( ! SHARED_FLAG )
	      {
		warning("placement directive for nonshared variable -- ignored");
		free_chain($2.text); free_chain($3.text);
	      }
	    else
	      {
		placement_directive( &$1 , &$3 );
		free_chain($2.text); free_chain($3.text);
	      }
	    $$ = $1;
	  }
	;



init:
	expr_no_commas            
             { $$ = $1; }

	| '{' '}'                 
             { 
	       $1.text = link_chain2( $1.text, $2.text );
	       $$ = $1;
	     }

	| '{' initlist '}'
	     { 
	       $1.text = link_chain3( $1.text, $2.text, $3.text );
	       $$ = $1;
	     }

	| '{' initlist ',' '}'
	     { 
	       $1.text = link_chain4( $1.text, $2.text, $3.text, $4.text );
	       $$ = $1;
	     }

	| error

	;

/* This chain is built in reverse order,
   and put in forward order where initlist is used.  */
initlist:
	  init
           { $$ = $1; }

	| initlist ',' init
           {
	     $1.text = link_chain3( $1.text, $2.text, $3.text );
	     $$ = $1;
	   }
 
	;

/* Any kind of declarator (thus, all declarators allowed
   after an explicit typespec).  */


declarator:
	  after_type_declarator { $$ = $1; }
	| notype_declarator     { $$ = $1; }
	;


/* A declarator that is allowed only after an explicit typespec.  */


after_type_declarator:
	  '(' after_type_declarator ')'
            { $$ = $2; }

	| after_type_declarator '(' parmlist_or_identifiers  %prec '.'
            { $$ = $1; }

	| after_type_declarator '[' expr ']'  %prec '.'
            { $$ = $1; }

	| after_type_declarator '[' ']'  %prec '.'
            { $$ = $1; }

	| '*' after_type_declarator  %prec UNARY
            { $$ = $2; }

	| TYPENAME
            {
	      error("attempt to redeclare a previously defined typedef");
	      $$ = $1;
	    }
	;


/* Kinds of declarator that can appear in a parameter list
   in addition to notype_declarator.  This is like after_type_declarator
   but does not allow a typedef name in parentheses as an identifier
   (because it would conflict with a function with that typedef as arg).  */


parm_declarator:
	  parm_declarator '(' parmlist_or_identifiers  %prec '.'
            { $$ = $1; }

	| parm_declarator '[' expr ']'  %prec '.'
            { $$ = $1; }

	| parm_declarator '[' ']'  %prec '.'
            { $$ = $1; }

	| '*'  parm_declarator  %prec UNARY
            { $$ = $2; }		

	| TYPENAME
            {
	      error("attempt to redeclare a previously defined typedef");
	    }
	;



/* A declarator allowed whether or not there has been
   an explicit typespec.  These cannot redeclare a typedef-name.  */

notype_declarator:
	  notype_declarator '(' parmlist_or_identifiers  %prec '.'
	   {

	     func_decl( &$1, &$2, &$3 );
	     $$ = $1;
	   }

	| '(' notype_declarator ')'
           { 
	     $2.text = link_chain3( $1.text, $2.text, $3.text);
	     $$ = $2;
	   }

	| '*'  notype_declarator  %prec HYPERUNARY
           {
/*	     printf("POINTER %s\n", TEXT($2.text)); */
	     pointer_decl( &$1, &$2 );
	     $$ = $2;
	   }

	| notype_declarator '[' expr ']'  %prec UNARY
           {
	     array_decl( &$1, &$2, &$3, &$4 );
	     $$ = $1;
	   }

	| notype_declarator '[' ']'  %prec UNARY
           {
	     empty_array_decl( &$1, &$2, &$3 );
	     $$ = $1;
	   }

	| IDENTIFIER
           {
	     identifier_decl( &$1 );

	     $$ = $1;
	   }
	;


store_structure_symbol:

                 {
		   make_empty_structure( &$-1 );
		 }
        ;

store_union_symbol:

                 {
		   make_empty_union( &$-1 );
		 }
        ;

structsp:
	  STRUCT  identifier  '{'  
             store_structure_symbol
             start_components_decl
	     component_decl_list 
             end_components_decl
            '}'  
                 {
		   fill_structure( &$2, &$6);
		   $2.text = 
		     link_chain5($1.text, $2.text, $3.text, $6.text, $8.text);
		   $$ = $2;

		 } 
		
        | STRUCT  '{'  
             start_components_decl
	     component_decl_list 
             end_components_decl
            '}'
                 {
		   Lex intname;

		   intname = new_internal_name();
		   make_empty_structure( &intname );
		   fill_structure( &intname, &$4 );
		   intname.text =
		     link_chain5($1.text, intname.text, $2.text, $4.text, $6.text);
		   $$ = intname;
		 }
		   
		      
	| STRUCT identifier
                 {
		   $$ = lookup_structure( &$2, 1 );
		   /* printf("%s:%d: lookup_structure(%s)\n", input_filename,
			  lineno, TEXT(((Lex *)(&$2))->text));*/
		   if ( SHARED_FLAG && !currdecl->components) {
		     $$.text = empty_string();
		     free_chain($1.text); free_chain($2.text);
		   }
		   else
		     $$.text = link_chain2( $1.text, $2.text );
		 }

	| UNION  identifier  '{' 
             store_union_symbol
             start_components_decl
	     component_decl_list 
             end_components_decl
            '}'  
                 {
		   fill_union( &$2, &$6);
		   $2.text = 
		     link_chain5($1.text, $2.text, $3.text, $6.text, $8.text);
		   $$ = $2;
		 } 
		
	| UNION  '{'  
             start_components_decl
	     component_decl_list 
             end_components_decl
            '}'
                 {
		   Lex intname;

		   intname = new_internal_name();
		   make_empty_union( &intname );
		   fill_union( &intname, &$4 );
		   intname.text =
		     link_chain5($1.text, intname.text, $2.text, $4.text, $6.text);
		   $$ = intname;
		 }

	| UNION  identifier
                 {
		   $$ = lookup_union( &$2, 1 );
		   if ( SHARED_FLAG && !currdecl->components) {
		     $$.text = empty_string();
		     free_chain($1.text); free_chain($2.text);
		   }
		   else
		     $$.text = link_chain2( $1.text, $2.text );
		 }

	| ENUM identifier '{'
              enumlist maybecomma_warn 
	     '}'
	         {
		   make_enum( &$2 );
		   $2.text =
		     link_chain5($1.text, $2.text, $3.text, $4.text, $6.text); 
		   $$ = $2;
		 }
	
	| ENUM  '{'
	       enumlist maybecomma_warn 
	     '}'
	         {
		   Lex intname;
		   
		   intname = new_internal_name();
		   make_enum( &intname );
		   intname.text =
		     link_chain5($1.text, intname.text, $2.text, $3.text, $5.text);
		   $$ = intname;
		 } 

 
	| ENUM identifier
                 {
		   $$ = lookup_enum( &$2 );
		   if ( SHARED_FLAG && !currdecl->components) {
		     $$.text = empty_string();
		     free_chain($1.text); free_chain($2.text);
		   }
		   else
		     $$.text = link_chain2( $1.text, $2.text );
		 }

	;


maybecomma_warn:
	  /* empty */

	| ','
           {
	     free_chain($1.text);
	     warning("comma at end of enum list -- ignored");
	   }
	;

start_components_decl:
          {
	    pushlevel_decl(); currdecl->components = TRUE;
	  }
        ;

end_components_decl:
          {
	    poplevel_decl();
	  }
        ;

component_decl_list:   /* empty */

          { 
	    reset_decl();
	    currdecl->components = TRUE;
	    $$ = empty_lex();
	  }

	| component_decl_list component_decl ';'
          {
	    if ( !xdecls_flag && SAVEPARMS_FLAG )
	      poplevel_tree();
 
	    $1.text = link_chain3( $1.text, $2.text, $3.text );
	    link_components( &$1, &$2 );
	    reset_decl();
	    currdecl->components = TRUE;
	    $$ = $1;
	  }
  
	| component_decl_list ';'
          {
	    if ( !xdecls_flag && SAVEPARMS_FLAG )
	      poplevel_tree();

	    $1.text = link_chain2( $1.text , $2.text );
	    reset_decl();
	    currdecl->components = TRUE;
	    $$ = $1;
	  }

	;

/* There is a shift-reduce conflict here, because `components' may
   start with a `typename'.  It happens that shifting (the default resolution)
   does the right thing, because it treats the `typename' as part of
   a `typed_typespecs'.

   It is possible that this same technique would allow the distinction
   between `notype_initdecls' and `initdecls' to be eliminated.
   But I am being cautious and not trying it.  */

component_decl:
	typed_typespecs  setspecs3 components
           {
	     $3.text = link_chain2( $1.text, $3.text );
	     $$ = $3;
	   }

	| nonempty_type_quals setspecs3  components
           {
	     $3.text = link_chain2( $1.text, $3.text );
	     $$ = $3;
	   }

	| error
	
	;

setspecs3:
          {
	    currdecl->type->typequals = currdecl->typequals;
	  }
        ;

components:
	  /* empty */

          { $$ = empty_lex(); }

	| component_declarator
          { 
	    if ( !xdecls_flag && SAVEPARMS_FLAG )
	      poplevel_tree();
	    
	    $$ = $1;
	  }

	| components ',' component_declarator
          {
	    if ( !xdecls_flag && SAVEPARMS_FLAG )
	      poplevel_tree();

	    $1.text = link_chain3( $1.text, $2.text, $3.text );
	    link_components( &$1, &$3 );

	    $$ = $1;
	  }
	;

component_declarator:
	declarator 
          { $$ = $1; }

	| declarator ':' expr_no_commas 
          { 
	    $1.text = link_chain3( $1.text, $2.text, $3.text );
	    if ( SHARED_FLAG )
	      error("bit fields not allowed in shared struct/unions");
	    $$ = $1;
	  }
	    
	| ':' expr_no_commas
          { 
	    $1.text = link_chain2( $1.text, $2.text );
	    if ( SHARED_FLAG )
	      error("bit fields not allowed in shared struct/unions");
	    $$ = $1;
	  }

	;

/* We chain the enumerators in reverse order.
   They are put in forward order where enumlist is used.
   (The order used to be significant, but no longer is so.
   However, we still maintain the order, just to be clean.)  */

enumlist:
	  enumerator
            { $$ = $1; }

	| enumlist ',' enumerator
            {
	      $1.text = link_chain3( $1.text, $2.text, $3.text );
	      $$ = $1;
	    }

	;


enumerator:
	  identifier
            {  
	      insert_enum_ident( &$1 );
 
	      $$ = $1;
	    }

	| identifier '=' expr_no_commas
            { 
	      insert_enum_ident( &$1 );

	      $1.text = link_chain3( $1.text, $2.text, $3.text );
	      $$ = $1;
	    }

	;

start_typename:
           { pushlevel_decl(); }
        ;

typename:
	start_typename typed_typespecs absdcl
           {
	     poplevel_decl();
	     $3.text = link_chain2( $2.text, $3.text );
	     $$ = $3;
	   }
	| start_typename nonempty_type_quals setspecs3 absdcl
           {
	     poplevel_decl();
	     $4.text = link_chain2( $2.text, $4.text );
	     $$ = $4;
	   }
	;

absdcl:   /* an absolute declarator */
	/* empty */
           {
	     $$ = empty_lex();
	     $$.tinfo = (Word)currdecl->type;
	   }

	| absdcl1
           { $$ = $1; }

	;

nonempty_type_quals:
	  TYPE_QUAL
           { new_typequal( &$1 ) ; $$ = $1; }

	| nonempty_type_quals TYPE_QUAL
           { add_typequal( &$1, &$2 ); $$ = $1; }

	;


absdcl1:  /* a nonempty absolute declarator */
	  '(' absdcl1 ')'
            {		
	      $2.text = link_chain3( $1.text, $2.text, $3.text );
	      $$ = $2;
	    }

	  /* `(typedef)1' is `int'.  */
	| '*'  absdcl1  %prec UNARY
            {		
	      pointer_type_decl( &$1, &$2 );
	      $$ = $2;
	    }
		
	| '*'   %prec UNARY 
            { 
	      Lex tmplex;

	      tmplex = empty_lex();
	      tmplex.tinfo = (Word)currdecl->type;
	      pointer_type_decl( &$1, &tmplex ); 
	      $$ = tmplex;
	    }
		
	| absdcl1 '(' parmlist  %prec '.'
            {	
	      func_type_decl( &$1, &$2, &$3 );
	      $$ = $1;
	    }

		
	| absdcl1 '[' expr ']'  %prec '.'
            {		
	      array_type_decl( &$1, &$2, &$3, &$4);
	      $$ = $1;
	    }

	| absdcl1 '[' ']'  %prec '.'
            {		
	      empty_array_type_decl( &$1, &$2, &$3 );
	      $$ = $1;
	    }
		
	| '(' parmlist  %prec '.'
            {	
	      Lex tmplex;

	      tmplex = empty_lex();
	      tmplex.tinfo = (Word)currdecl->type;
	
	      func_type_decl( &tmplex, &$1, &$2 );
	      $$ = tmplex;
	    }

	| '[' expr ']'  %prec '.'
            {		
	      Lex tmplex;

	      tmplex = empty_lex();
	      tmplex.tinfo = (Word)currdecl->type;

	      array_type_decl( &tmplex, &$1, &$2, &$3);
	      $$ = tmplex;
	    }

	| '[' ']'  %prec '.'
            {		
	      Lex tmplex;

	      tmplex = empty_lex();
	      tmplex.tinfo = (Word)currdecl->type;

	      empty_array_type_decl( &tmplex, &$1, &$2 );
	      $$ = tmplex;
	    }
		
	;

/* at least one statement, the first of which parses without error.  */
/* stmts is used only after decls, so an invalid first statement
   is actually regarded as an invalid decl and part of the decls.  */

stmts:
	| stmts stmt
	| stmts errstmt
	;

xstmts:
	/* empty */
	| stmts
	;

errstmt:  error ';'
	;

pushlevel:  /* empty */
           {
	     out1( &$0 );
	     if ( !SAVEPARMS_FLAG ) 
	       pushlevel_tree();
	     else
	       SAVEPARMS_FLAG = FALSE;
	   }
	;

/* This is the body of a function definition.
   It causes syntax errors to ignore to the next openbrace.  */
compstmt_or_error:
	  compstmt
	
	| error compstmt
	;

 compstmt: '{' '}'
            { 
              if (SAVEPARMS_FLAG)
                poplevel_tree();
	      out2( &$1, &$2);
            }

	| '{' pushlevel decls xstmts '}'
            {
	      out1( &$5 );
	      poplevel_tree();
	    }

	| '{' pushlevel error '}'
            {
              poplevel_tree();
            }
	
	| '{' pushlevel stmts '}'
            {
	      out1( &$4 );
	      poplevel_tree();
	    }
	
	;


simple_if:
	  IF  '(' expr ')'                  {out4( &$1, &$2, &$3, &$4 );}
	
	  stmt
	;



stmt:
	  compstmt	

	| expr ';'                          {out2( &$1, &$2 );}
		
	| simple_if ELSE                    {out1( &$2 );}
	
	  stmt
		
	| simple_if %prec IF
		
	| WHILE  '(' expr ')'               {out4( &$1, &$2, &$3, &$4 );}
	
	  stmt
	
	| DO                                {out1( &$1 );}

	  stmt 

          WHILE '(' expr ')'  ';'           {out5( &$4, &$5, &$6, &$7, &$8 );}

	| FOR '('                           {out2( &$1, &$2 );}

          xexpr ';'                         {out2( &$4, &$5 );}
	
	  xexpr ';'                         {out2( &$7, &$8 );}

	  xexpr ')'                         {out2( &$10, &$11 );}

	  stmt
	
	| SWITCH  '('                       {out2( &$1, &$2 );} 

          expr  ')'                         {out2( &$4, &$5 );}
	
	  stmt
	
	| CASE                              {out1( &$1 );}

          expr ':'                          {out2( &$3, &$4 );}
	
	  stmt

	| DEFAULT ':'                       {out2( &$1, &$2 );}
	
	  stmt

	| BREAK  ';'                        {out2( &$1, &$2 );} 
	
	| CONTINUE  ';'                     {out2( &$1, &$2 );} 
	
	| RETURN  ';'                       {out2( &$1, &$2 );}
	
	| RETURN expr ';'                   {out3( &$1, &$2, &$3 );}
	
	| GOTO  identifier  ';'             {out3( &$1, &$2, &$3 );}
	
	| identifier  ':'                   {out2( &$1, &$2 );}
	
	  stmt

	| ';'                               {out1( &$1 );} 

	;



xexpr:
	/* empty */
          { $$ = empty_lex(); }

	| expr
          { $$ = $1; }

	;


/* This is what appears inside the parens in a function declarator.
   Its value is a list of ..._TYPE nodes.  */
parmlist:

	    { pushlevel_decl(); }
          parmlist_1
            { poplevel_decl();  $$ = $2; }	
	;

/* This is referred to where either a parmlist or an identifier list is ok.
   Its value is a list of ..._TYPE nodes or a list of identifiers.  */
parmlist_or_identifiers:
      
	  setsaveparms parmlist_or_identifiers_1
            { poplevel_decl(); $$ = $2; }
	;

setsaveparms:
            {
	      if ( !xdecls_flag ) { 
		pushlevel_tree();
		SAVEPARMS_FLAG = TRUE;
	      }
	      pushlevel_decl();
	    }

parmlist_or_identifiers_1:
	  parmlist_2 ')'
            {
	      $1.text = link_chain2( $1.text, $2.text );
	      $$ = $1;
	    }

	| identifiers ')'
            {
	      $1.text = link_chain2( $1.text, $2.text );
	      $$ = $1;
	    }
	
	| error ')'

	;

parmlist_1:
	  parmlist_2 ')'
            {
	      $1.text = link_chain2( $1.text, $2.text );
	      $$ = $1;
	    }

	| error ')'

	;

/* This is what appears inside the parens in a function declarator.
   Is value is represented in the format that grokdeclarator expects.  */
parmlist_2:  /* empty */
            { $$ = empty_lex(); }

	| parms
            { $$ = $1; }
		
	| parms ',' ELLIPSIS
            {
	      $1.text = link_chain3( $1.text, $2.text, $3.text );
	      $$ = $1; 
	    }
	;

parms:
	parm
           {
	     if ( SAVEPARMS_FLAG )
	       poplevel_tree();
	     
	     reset_decl();

	     $$ = $1;
	   }

	| parms ',' parm
           {	
	     if ( SAVEPARMS_FLAG )
	       poplevel_tree();
	     
	     $1.text = link_chain3( $1.text, $2.text, $3.text );

	     reset_decl();

	     $$ = $1;
	   }
	;

/* A single parameter declaration or parameter type name,
   as found in a parmlist.  */
parm:
	  typed_typespecs parm_declarator
           {
	     $2.text = link_chain2( $1.text, $2.text );
	     $$ = $2;
	   }

	| typed_typespecs notype_declarator
           {
	     if ( SAVEPARMS_FLAG_1 )
	       insert_symbol( (Symbol *)$2.tinfo, TREEOF($2) );
	     
	     $2.text = link_chain2( $1.text, $2.text );
	     $$ = $2;
	   }

	| typed_typespecs absdcl
           {
	     $2.text = link_chain2( $1.text, $2.text );
	     $$ = $2;
	   }

	| nonempty_type_quals notype_declarator
           {
	     if ( SAVEPARMS_FLAG_1 )
	       insert_symbol( (Symbol *)$2.tinfo, TREEOF($2) );

	     $2.text = link_chain2( $1.text, $2.text );
	     $$ = $2;
	   }

	| nonempty_type_quals absdcl
           {
	     $2.text = link_chain2( $1.text, $2.text );
	     $$ = $2;
	   }
		
	;

/* A nonempty list of identifiers.  */
identifiers:

	IDENTIFIER
           {
	     
	     if ( SAVEPARMS_FLAG_1 ) {
	       identifier_decl( &$1 );
	       insert_symbol( (Symbol *)$1.tinfo, TREEOF($1) );
	     }

	     $$ = $1;
	   }
		
	| identifiers ',' IDENTIFIER
           {

	     if ( SAVEPARMS_FLAG_1 ) {
	       identifier_decl( &$3 );
	       insert_symbol( (Symbol *)$3.tinfo, TREEOF($1) );
	     }

	     $3.text = link_chain3( $1.text, $2.text, $3.text );
	     $$ = $3;
	   }
	;
%%


StrTab *allocate_string();
Symbol *lookup_table();

extern int lineno;	    /* current line number in file being read */

extern FILE *finput;	    /* input file.
			       Normally a pipe from the preprocessor.  */

extern FILE *foutput;       /* output file. */

/* lexical analyzer */

static int maxtoken = MAX_TOKEN;
static char token_buffer[MAX_TOKEN+2];

int dollars_in_ident = FALSE;
int pedantic = FALSE;

/* Nonzero if end-of-file has been seen on input.  */
static int end_of_file;


struct resword { char *name; short token; short rid; };

struct resword *is_reserved_word (char *str)
{	
    struct resword *rptr;
    int cmp;

    static struct resword reswords[] = 
      {
	{"__alignof",  ALIGNOF,  NORID },
	{"__alignof__",  ALIGNOF,  NORID },
	{"__asm",  ASM,  NORID },
	{"__asm__",  ASM,  NORID },
	{"__attribute",  ATTRIBUTE,  NORID },
	{"__attribute__",  ATTRIBUTE,  NORID },
	{"__const",  TYPE_QUAL,  RID_CONST },
	{"__const__",  TYPE_QUAL,  RID_CONST },
	{"__inline",  SCSPEC,  RID_INLINE },
	{"__inline__",  SCSPEC,  RID_INLINE },
	{"__signed",  TYPE_QUAL,  RID_SIGNED },
	{"__signed__",  TYPE_QUAL,  RID_SIGNED },
	{"__typeof",  TYPEOF,  NORID },
	{"__typeof__",  TYPEOF,  NORID },
	{"__volatile",  TYPE_QUAL,  RID_VOLATILE },
	{"__volatile__",  TYPE_QUAL,  RID_VOLATILE },
	{"asm",  ASM,  NORID },
	{"auto",  SCSPEC,  RID_AUTO },
	{"break",  BREAK,  NORID },
	{"case",  CASE,  NORID },
	{"char",  TYPESPEC,  RID_CHAR },
	{"const",  TYPE_QUAL,  RID_CONST },
	{"continue",  CONTINUE,  NORID },
	{"default",  DEFAULT,  NORID },
	{"do",  DO,  NORID },
	{"double",  TYPESPEC,  RID_DOUBLE },
	{"else",  ELSE,  NORID },
	{"enum",  ENUM,  NORID },
	{"extern",  SCSPEC,  RID_EXTERN },
	{"float",  TYPESPEC,  RID_FLOAT },
	{"for",  FOR,  NORID },
	{"goto",  GOTO,  NORID },
	{"if",  IF,  NORID },
	{"inline",  SCSPEC,  RID_INLINE },
	{"int",  TYPESPEC,  RID_INT },
/*
	{"interrupt",  INTERRUPT,  NORID },
*/
	{"ipi", IPI, NORID},
	{"long",  TYPESPEC,  RID_LONG },
	{"placeat", PLACEAT, NORID},
	{"register",  SCSPEC,  RID_REGISTER },
	{"return",  RETURN,  NORID },
	{"shared",  SCSPEC,  RID_SHARED },
	{"short",  TYPESPEC,  RID_SHORT },
	{"signed",  TYPE_QUAL,  RID_SIGNED },
	{"sizeof",  SIZEOF,  NORID },
	{"soft", SCSPEC, RID_SOFT},
	{"static",  SCSPEC,  RID_STATIC },
	{"struct",  STRUCT,  NORID },
	{"switch",  SWITCH,  NORID },
	{"tag",  TAG,  NORID },
	{"tagged",  SCSPEC,  RID_TAGGED },
/*
        {"tagoff", TAGOFF, NORID },
        {"tagon", TAGON, NORID },
*/
	{"typedef",  SCSPEC,  RID_TYPEDEF },
	{"typeof",  TYPEOF,  NORID },
	{"union",  UNION,  NORID },
	{"unsigned",  TYPE_QUAL,  RID_UNSIGNED },
	{"untagged", SCSPEC, RID_UNTAGGED },
	{"void",  TYPESPEC,  RID_VOID },
	{"volatile",  TYPE_QUAL,  RID_VOLATILE },
	{"while",  WHILE,  NORID },
	0
	};


    for(rptr = reswords, cmp = 1; rptr->name != 0 && cmp > 0; rptr++)
      if( !( cmp = strcmp(str, rptr->name)) ) return rptr;

    return 0;
  }


Type *type_descr[10];


StrTab *int_text, *char_text, *float_text, *double_text, *short_text,
       *long_text, *void_text, *ptr_text, *fnptr_text;

int check_newline ();



Type *make_type(Word tid, StrTab *text, int size)
{
  Type *tptr = newtype();
  tptr->tid = tid;
  tptr->text = text;
  tptr->size = size;
  
  return tptr;
}

StrTab *empty_string()
{
  return( allocate_string( "" ) );
}

Lex empty_lex()
{
  Lex l;

  l.text = empty_string();
  l.tinfo = (Word)NULL;

  return l;
}



void
init_lex ()
{
  /* Start it at 0, because check_newline is called at the very beginning
     and will increment it to 1.  */
  lineno = 0;

  int_text  = allocate_string("int");
  char_text = allocate_string("char");
  float_text = allocate_string("float");
  double_text = allocate_string("double");
  short_text = allocate_string("short");
  long_text = allocate_string("long");
  void_text = allocate_string("void");

  type_descr[(int) RID_INT] =
    make_type(RID_INT, int_text, SIZE_INT);
  type_descr[(int) RID_CHAR] =
    make_type(RID_CHAR, char_text, SIZE_CHAR);
  type_descr[(int) RID_FLOAT] =
    make_type(RID_FLOAT, float_text, SIZE_FLOAT);
  type_descr[(int) RID_DOUBLE] =
    make_type(RID_DOUBLE, double_text, SIZE_DOUBLE);
  type_descr[(int) RID_SHORT] =
    make_type(RID_SHORT, short_text, SIZE_SHORT);
  type_descr[(int) RID_LONG] =
    make_type(RID_LONG, long_text, SIZE_LONG);
  type_descr[(int) RID_VOID] =
    make_type(RID_VOID, void_text, SIZE_VOID);

  error_flag = 0;

  ungetc( check_newline(), finput );

  reset_decl();

}



void print_token(int value)
{
  printf("\"%s\":%d Token %s Value %d Tinfo %06o\n", 
	 input_filename,
	 lineno,
	 TEXT(yylval.text), 
	 value,
	 yylval.tinfo);
}


void token_overflow(void)
{
  fatal("too long token encountered (max size = %s) -- abort!", maxtoken);
}

extern void newline(int);

/* this macro is useful for checking something after every line */
#define INC_LINENO() \
  do{ lineno++; /* newline(lineno); */ } while(0)


/* If C is not whitespace, return C.
   Otherwise skip whitespace and return first nonwhite char read.  */

static int
skip_white_space (c)
     register int c;
{
#ifdef SKIP_COMMENTS
  register int inside;
#endif

  for (;;)
    {
      switch (c)
	{
	  /* Don't recognize comments in cc1: all comments are removed by cpp,
	     and cpp output can include / and * consecutively as operators.  */
#ifdef SKIP_COMMENTS
	case '/':
	  c = getc (finput);
	  if (c != '*')
	    {
	      ungetc (c, finput);
	      return '/';
	    }

	  c = getc (finput);

	  inside = 1;
	  while (inside)
	    {
	      if (c == '*')
		{
		  while (c == '*') {
		    c = getc (finput);
		  }

		  if (c == '/')
		    {
		      inside = 0;
		      c = getc (finput);
		    }
		}
	      else if (c == '\n')
		{
		  INC_LINENO();
		  c = getc (finput);
		}
	      else if (c == EOF)
		{
		  error ("unterminated comment");
		  break;
		}
	      else
		{
		  c = getc (finput);
		}
	    }

	  break;
#endif

	case '\n':
	  c = check_newline ();
	  break;

	case ' ':
	case '\t':
	case '\f':
	case '\r':
	case '\v':
	case '\b':
	  c = getc (finput);
	  break;

	case '\\':
	  c = getc (finput);
	  if (c == '\n') {
	      INC_LINENO();
	  } else
	    error("stray '\\' in program");
	  c = getc (finput);
	  break;

	default:
	  return (c);
	}
    }
}



/* At the beginning of a line, increment the line number
   and process any #-directive on this line.
   If the line is a #-directive, read the entire line and return a newline.
   Otherwise, return the line's first non-whitespace character.  */



int
check_newline ()
{
  register int c;
  register int token;

  INC_LINENO();

  /* Read first nonwhite char on the line.  */

  c = getc (finput);
  while (c == ' ' || c == '\t')
    c = getc (finput);

  if (c != '#')
    {
      /* If not #, return it so caller will use it.  */
      return c;
    }

  /* Read first nonwhite char after the `#'.  */

  c = getc (finput);
  while (c == ' ' || c == '\t')
    c = getc (finput);

  /* If a letter follows, then if the word here is `line', skip
     it and ignore it; otherwise, ignore the line, with an error
     if the word isn't `pragma'.  */

  if ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))
    {
      if (c == 'p')
	{
	  if (getc (finput) == 'r'
	      && getc (finput) == 'a'
	      && getc (finput) == 'g'
	      && getc (finput) == 'm'
	      && getc (finput) == 'a'
	      && ((c = getc (finput)) == ' ' || c == '\t' || c == '\n'))
	    goto skipline;
	}

      else if (c == 'l')
	{
	  if (getc (finput) == 'i'
	      && getc (finput) == 'n'
	      && getc (finput) == 'e'
	      && ((c = getc (finput)) == ' ' || c == '\t'))
	    goto linenum;
	}
      

      error ("undefined or invalid # directive");
      goto skipline;
    }

linenum:
  /* Here we have either `#line' or `# <nonletter>'.
     In either case, it should be a line number; a digit should follow.  */

  while (c == ' ' || c == '\t')
    c = getc (finput);

  /* If the # is the only nonwhite char on the line,
     just ignore it.  Check the new newline.  */
  if (c == '\n')
    return c;

  /* Something follows the #; read a token.  */

  ungetc (c, finput);
  token = yylex ();

  if (token == CONSTANT
      && atoi( TEXT(yylval.text) ) )
    {
      /* subtract one, because it is the following line that
	 gets the specified number */

      int l = atoi( TEXT(yylval.text) ) - 1;

      /* Is this the last nonwhite stuff on the line?  */
      c = getc (finput);
      while (c == ' ' || c == '\t')
	c = getc (finput);
      if (c == '\n')
	{
	  /* No more: store the line number and check following line.  */
	  lineno = l;
	  return c;
	}
      ungetc (c, finput);

      /* More follows: it must be a string constant (filename).  */

      token = yylex ();
      if (token != STRING)
	{
	  error ("invalid #line");
	  goto skipline;
	}

      input_filename = TEXT(yylval.text)+1;
      *(input_filename + strlen(input_filename) -1) = 0;

      lineno = l;

      /* Is this the last nonwhite stuff on the line?  */
      c = getc (finput);
      while (c == ' ' || c == '\t')
	c = getc (finput);
      if (c == '\n')
	return c;
      ungetc (c, finput);

      token = yylex ();

      /* `1' after file name means entering new file.
	 `2' after file name means just left a file.  */

      if (token == CONSTANT
	  &&  atoi( TEXT(yylval.text) ) )
	{
/*
	  if ( val == 1 )
	    {
	      struct file_stack *p
		= (struct file_stack *) malloc (sizeof (struct file_stack));
	      input_file_stack->line = old_lineno;
	      p->next = input_file_stack;
	      p->name = input_filename;
	      input_file_stack = p;
	      input_file_stack_tick++;
	    }
	  else if (input_file_stack->next)
	    {
	      struct file_stack *p = input_file_stack;
	      input_file_stack = p->next;
	      free (p);
	      input_file_stack_tick++;
	    }
	  else
	    error ("#-lines for entering and leaving files don't match");
*/
	}
    }
  else
    error ("invalid #-line");

  /* skip the rest of this line.  */
 skipline:
  if (c == '\n')
    return c;
  while ((c = getc (finput)) != EOF && c != '\n');
  return c;
}





#define isalnum(char) ((char >= 'a' && char <= 'z') || (char >= 'A' && char <= 'Z') || (char >= '0' && char <= '9'))
#define isdigit(char) (char >= '0' && char <= '9')
#define ENDFILE -1  /* token that represents end-of-file */


void
yyerror (string)
     char *string;
{
  char buf[2000];

  strcpy (buf, string);

  /* We can't print string and character constants well
     because the token_buffer contains the result of processing escapes.  */
  if (end_of_file)
    strcat (buf, " at end of input");
  else if (token_buffer[0] == 0)
    strcat (buf, " at null character");
  else if (token_buffer[0] == '\"')
    strcat (buf, " before string constant");
  else if (token_buffer[0] == '\'')
    strcat (buf, " before character constant");
  else if (token_buffer[0] < 040 || token_buffer[0] >= 0177)
    sprintf (buf + strlen (buf), " before character 0%o", token_buffer[0]);
  else
    strcat (buf, " before `%s\'");

  error (buf, token_buffer);
}

static int nextchar = -1;


int yylex()
{
  register int c;
  register char *p;
  register int value;

  if (nextchar >= 0)
    c = nextchar, nextchar = -1;
  else
    c = getc (finput);

  /* Effectively do c = skip_white_space (c)
     but do it faster in the usual cases.  */
  while (1)
    switch (c)
      {
      case ' ':
      case '\t':
      case '\f':
      case '\r':
      case '\v':
      case '\b':
	c = getc (finput);
	break;

      case '\n':
      case '/':
      case '\\':
	c = skip_white_space (c);
      default:
	goto found_nonwhite;
      }
 found_nonwhite:

  yylval.tinfo = 0;

  token_buffer[0] = c;
  token_buffer[1] = 0;

/*  yylloc.first_line = lineno; */

  switch (c)
    {
    case EOF:
      end_of_file = 1;
      token_buffer[0] = 0;
      value = ENDFILE;
      break;

    case '$':
      if (dollars_in_ident)
	goto letter;
      return '$';

    case 'L':
      /* Capital L may start a wide-string or wide-character constant.  */
      {
	register int c = getc (finput);
	if (c == '\'')
	  {
	    warning("wide-char constants not supported -- L ignored");
	    goto char_constant;
	  }
	if (c == '\"')
	  {
	    warning("wide-string constants not supported -- L ignored");
	    goto string_constant;
	  }
	ungetc (c, finput);
      }

    case 'A':  case 'B':  case 'C':  case 'D':  case 'E':
    case 'F':  case 'G':  case 'H':  case 'I':  case 'J':
    case 'K':		  case 'M':  case 'N':  case 'O':
    case 'P':  case 'Q':  case 'R':  case 'S':  case 'T':
    case 'U':  case 'V':  case 'W':  case 'X':  case 'Y':
    case 'Z':
    case 'a':  case 'b':  case 'c':  case 'd':  case 'e':
    case 'f':  case 'g':  case 'h':  case 'i':  case 'j':
    case 'k':  case 'l':  case 'm':  case 'n':  case 'o':
    case 'p':  case 'q':  case 'r':  case 's':  case 't':
    case 'u':  case 'v':  case 'w':  case 'x':  case 'y':
    case 'z':
    case '_':
    letter:
      p = token_buffer;
      while (isalnum (c) || c == '_' || c == '$')
	{
	  if (p >= token_buffer + maxtoken)
	    token_overflow();

	  if (c == '$' && ! dollars_in_ident)
	    break;

	  *p++ = c;
	  c = getc (finput);
	}

      *p = 0;
      nextchar = c;

      value = IDENTIFIER;

      /* Try to recognize a keyword. */

      {
	register struct resword *ptr;

	if (ptr = is_reserved_word(token_buffer)) {
	  if (ptr->token == TYPESPEC) {
	    Type *type = type_descr[ptr->rid],
	         *tptr = newtype();

	    tptr->tid  = type->tid;
	    tptr->text = copy_string(type->text);
	    tptr->size = type->size;
	    yylval.tinfo = (Word)tptr;
	  }
	  else
	    yylval.tinfo = (Word)ptr->rid;
	  value = (int) ptr->token;
	}
      }

      /* If we did not find a keyword, look for an identifier
	 (or a typename).  */

      if (value == IDENTIFIER)
	{
	  Symbol *symbol = lookup_symbol_rec(token_buffer, currtree);

	  if ( symbol != (Symbol *)NOTFOUND )
	    {
	      if ( symbol->class == ID_USERIPI ) {
		sprintf(token_buffer,"%d", symbol->attributes);
		yylval.tinfo = (Word)NULL;
		value = CONSTANT;
	      } else {
		yylval.tinfo = (Word)symbol;
		if (symbol->class == ID_TYPEDEF) 
		  value = TYPENAME;
	      }
	    }
	  else 
	    yylval.tinfo = (Word)NULL;
	}

      break;

    case '0':  case '1':  case '2':  case '3':  case '4':
    case '5':  case '6':  case '7':  case '8':  case '9':
    case '.':
      {
	int constant_type = RID_INT;
	int base = 10;
	int count = 0;
	int largest_digit = 0;
	int numdigits = 0;
	/* for multi-precision arithmetic,
	   we store only 8 live bits in each short,
	   giving us 64 bits of reliable precision */
	short shorts[8];
	int overflow = 0;

	enum anon1 { NOT_FLOAT, AFTER_POINT, TOO_MANY_POINTS} floatflag
	  = NOT_FLOAT;

	for (count = 0; count < 8; count++)
	  shorts[count] = 0;

	p = token_buffer;
	*p++ = c;

	if (c == '0')
	  {
	    *p++ = (c = getc (finput));
	    if ((c == 'x') || (c == 'X'))
	      {
		base = 16;
		*p++ = (c = getc (finput));
	      }
	    else
	      {
		base = 8;
		numdigits++;
	      }
	  }

	/* Read all the digits-and-decimal-points.  */

	while (c == '.'
	       || (isalnum (c) && (c != 'l') && (c != 'L')
		   && (c != 'u') && (c != 'U')
		   && (floatflag == NOT_FLOAT || ((c != 'f') && (c != 'F')))))
	  {
	    if (c == '.')
	      {
		if (base == 16)
		  error ("floating constant may not be in radix 16");
		if (floatflag == AFTER_POINT)
		  {
		    error ("malformed floating constant");
		    floatflag = TOO_MANY_POINTS;
		  }
		else {
		  constant_type = RID_FLOAT;
		  floatflag = AFTER_POINT;
		}

		base = 10;
		*p++ = c = getc (finput);
		/* Accept '.' as the start of a floating-point number
		   only when it is followed by a digit.
		   Otherwise, unread the following non-digit
		   and use the '.' as a structural token.  */
		if (p == token_buffer + 2 && !isdigit (c))
		  {
		    if (c == '.')
		      {
			c = getc (finput);
			if (c == '.')
			  {
			    *p++ = c;
			    *p = 0;
			    value = yylval.tinfo = ELLIPSIS; goto done;
			  }
			error ("parse error at `..\'");
		      }
		    ungetc (c, finput);
		    token_buffer[1] = 0;
		    value = '.';
		    goto done;
		  }
	      }
	    else
	      {
		/* It is not a decimal point.
		   It should be a digit (perhaps a hex digit).  */

		if (isdigit (c))
		  {
		    c = c - '0';
		  }
		else if (base <= 10)
		  {
		    if ((c&~040) == 'E')
		      {
			base = 10;
			constant_type = RID_FLOAT;
			floatflag = AFTER_POINT;
			break;   /* start of exponent */
		      }
		    error ("nondigits in number and not hexadecimal");
		    c = 0;
		  }
		else if (c >= 'a')
		  {
		    c = c - 'a' + 10;
		  }
		else
		  {
		    c = c - 'A' + 10;
		  }
		if (c >= largest_digit)
		  largest_digit = c;
		numdigits++;

		for (count = 0; count < 8; count++)
		  {
		    shorts[count] *= base;
		    if (count)
		      {
			shorts[count] += (shorts[count-1] >> 8);
			shorts[count-1] &= (1<<8)-1;
		      }
		    else shorts[0] += c;
		  }

		if (shorts[7] >= 1<<8
		    || shorts[7] < - (1 << 8))
		  overflow = TRUE;

		if (p >= token_buffer + maxtoken)
		  token_overflow();

		*p++ = (c = getc (finput));
	      }
	  }

	if (numdigits == 0)
	  error ("numeric constant with no digits");

	if (largest_digit >= base)
	  error ("numeric constant contains digits beyond the radix");

	/* Remove terminating char from the token buffer and delimit the string */
	*--p = 0;
      
	if (floatflag != NOT_FLOAT)
	  {
	    char f_seen = 0;
	    char l_seen = 0;

	    /* Read explicit exponent if any, and put it in tokenbuf.  */

	    if ((c == 'e') || (c == 'E'))
	      {
		if (p >= token_buffer + maxtoken)
		  token_overflow();
		*p++ = c;
		c = getc (finput);
		if ((c == '+') || (c == '-'))
		  {
		    *p++ = c;
		    c = getc (finput);
		  }
		if (! isdigit (c))
		  error ("floating constant exponent has no digits");
	        while (isdigit (c))
		  {
		    if (p >= token_buffer + maxtoken)
		      token_overflow();
		    *p++ = c;
		    c = getc (finput);
		  }
	      }

	    *p = 0;

	    /* Read the suffixes to choose a data type.  */
	    while (1)
	      {
		if (c == 'f' || c == 'F')
		  {
		    if (f_seen)
		      error ("two `f\'s in floating constant");
		    f_seen = 1;
		  }
		else if (c == 'l' || c == 'L')
		  {
		    if (l_seen)
		      error ("two `l\'s in floating constant");
		    constant_type = RID_DOUBLE;
		    l_seen = 1;
		  }
		else
		  {
		    if (isalnum (c))
		      {
			error ("garbage at end of number");
			while (isalnum (c))
			  {
			    if (p >= token_buffer + maxtoken)
			      token_overflow();
			    *p++ = c;
			    c = getc (finput);
			  }
		      }
		    break;
		  }
		if (p >= token_buffer + maxtoken)
		  token_overflow();
		*p++ = c;
		c = getc (finput);
	      }

	    ungetc (c, finput);
	    *p = 0;
	  }
	else
	  {
	    int spec_unsigned = 0;
	    int spec_long = 0;
	    int spec_long_long = 0;

	    while (1)
	      {
		if (c == 'u' || c == 'U')
		  {
		    if (spec_unsigned)
		      error ("two `u\'s in integer constant");
		    spec_unsigned = 1;
		  }
		else if (c == 'l' || c == 'L')
		  {
		    if (spec_long)
		      {
			if (spec_long_long)
			  error ("three `l\'s in integer constant");
			else if (pedantic)
			  warning ("ANSI C forbids long long integer constants");
			spec_long_long = 1;
		      }
		    constant_type = RID_LONG;
		    spec_long = 1;
		  }
		else
		  {
		    if (isalnum (c))
		      {
			error ("garbage at end of number");
			while (isalnum (c))
			  {
			    if (p >= token_buffer + maxtoken)
			      token_overflow();
			    *p++ = c;
			    c = getc (finput);
			  }
		      }
		    break;
		  }
		if (p >= token_buffer + maxtoken)
		  token_overflow();
		*p++ = c;
		c = getc (finput);
	      }

	    ungetc (c, finput);
	    *p = 0;

	    if ((overflow || shorts[7] || shorts[6] || shorts[5] || shorts[4])
		&& !spec_long_long)
	      warning ("integer constant out of range");

	    /* If it won't fit in a signed long long, make it unsigned.
	       We can't distinguish based on the tree node because
	       any integer constant fits any long long type.  */
	    if (shorts[7] >= (1<<8))
	      spec_unsigned = 1;
	  }
	
	{

	  Type *type = type_descr[constant_type],
	       *tptr = newtype();
	  
	  tptr->tid  = type->tid;
	  tptr->text = copy_string(type->text);
	  tptr->size = type->size;
	  yylval.tinfo = (Word)tptr;
	}

	    value = CONSTANT; *p = 0; break;
      }

    case '\'':
    char_constant:
      {
	char escape_flag = FALSE;

	p = token_buffer;

	do {
	  if (p >= token_buffer + maxtoken)
	    token_overflow();
	  *p++ = c;

	  if ( !escape_flag && c == '\\' )
	    escape_flag = TRUE;
	  else
	    escape_flag = FALSE;

	  c = getc(finput);
	} while( (c != '\'' || escape_flag) && c != EOF);

	*p++ = '\'';
	*p = 0;

	{

	  Type *type = type_descr[RID_CHAR],
	       *tptr = newtype();
	  
	  tptr->tid  = type->tid;
	  tptr->text = copy_string(type->text);
	  tptr->size = type->size;
	  yylval.tinfo = (Word)tptr;
	}
	
	value = CHARCONSTANT; break;
      }

    case '\"':
    string_constant:
      {
	char escape_flag = FALSE;

	p = token_buffer;

	do {
	  if (p >= token_buffer + maxtoken)
	    token_overflow();
	  *p++ = c;

	  if ( !escape_flag && c == '\\' )
	    escape_flag = TRUE;
	  else
	    escape_flag = FALSE;

	  c = getc(finput);
	} while( (c != '\"' || escape_flag) && c != EOF);

	*p++ = '\"';
	*p = 0;

	{

	  Type *type = type_descr[RID_CHAR],
	       *tptr = newtype();
	  
	  tptr->tid  = type->tid;
	  tptr->text = copy_string(type->text);
	  tptr->size = type->size;
	  yylval.tinfo = (Word)insert_pointer(tptr);
	}

	value = STRING; break;

      }

    case '+':
    case '-':
    case '&':
    case '|':
    case '<':
    case '>':
    case '*':
    case '/':
    case '%':
    case '^':
    case '!':
    case '=':
    case '@':
        { 
	register int c1, i;

      combine:
	
	i = 1;
	switch (c)
	  {
	  case '+':
	    yylval.tinfo = PLUS_EXPR; break;
	  case '-':
	    yylval.tinfo = MINUS_EXPR; break;
	  case '&':
	    yylval.tinfo = BIT_AND_EXPR; break;
	  case '|':
	    yylval.tinfo = BIT_IOR_EXPR; break;
	  case '*':
	    yylval.tinfo = MULT_EXPR; break;
	  case '/':
	    yylval.tinfo = TRUNC_DIV_EXPR; break;
	  case '%':
	    yylval.tinfo = TRUNC_MOD_EXPR; break;
	  case '^':
	    yylval.tinfo = BIT_XOR_EXPR; break;
	  case LSHIFT:
	    yylval.tinfo = LSHIFT_EXPR; i=2; break;
	  case RSHIFT:
	    yylval.tinfo = RSHIFT_EXPR; i=2; break;
	  case '<':
	    yylval.tinfo = LESS_EXPR; break;
	  case '>':
	    yylval.tinfo = GRT_EXPR; break;
	  }


	token_buffer[i] = c1 = getc (finput);
	token_buffer[i+1] = 0;

	if (c1 == '=')
	  {
	    switch (c)
	      {
	      case '<':
		value = ARITHCOMPARE; yylval.tinfo = LEQ_EXPR; goto done;
	      case '>':
		value = ARITHCOMPARE; yylval.tinfo = GEQ_EXPR; goto done;
	      case '!':
		value = EQCOMPARE; yylval.tinfo = NEQ_EXPR; goto done;
	      case '=':
		value = EQCOMPARE; yylval.tinfo = EQ_EXPR; goto done;
	      }
	    /* Abbreviated assignment. yylval.tinfo shows which op */
	    value = ASSIGN; goto done;
	  }
	else if (c == c1)
	  switch (c)
	    {
	    case '+':
	      value = PLUSPLUS; goto done;
	    case '-':
	      value = MINUSMINUS; goto done;
	    case '&':
	      value = ANDAND; goto done;
	    case '|':
	      value = OROR; goto done;
	    case '<':
	      c = LSHIFT;
	      goto combine;
	    case '>':
	      c = RSHIFT;
	      goto combine;
	    }
	else if ((c == '-') && (c1 == '>'))
	  { value = POINTSAT; goto done; }
	else if ((c == '@') && (c1 == '>'))
	  { value = SHPOINTSAT; goto done; }
	ungetc (c1, finput);
	token_buffer[i] = 0;

	if ((c == '<') || (c == '>'))
	  value = ARITHCOMPARE;
	else value = c;
	goto done;
      }

    case 0:
      /* Don't make yyparse think this is eof.  */
      value = 1;
      break;

    default:
      value = c;
    }

done:
/*  yylloc.last_line = lineno; */

  yylval.text = allocate_string(token_buffer);

#ifdef DEBUG
  printf("%s ", token_buffer);
#endif

  return value;
}
