
#include "cprep.h"
#include "symtable.h"

#define OTHER(i)         (1-i)
#define TOGGLE(i)        (i = 1-i)


char *sign_text(Type *t)
{
    char *sign = "";
    
    if ( t != (Type *)NULL )
      switch ( t->tid )
	{
	  case RID_CHAR:
	  case RID_INT:
	  case RID_SHORT:
	  case RID_LONG:	
	    switch ( t->typequals & (RID_SIGNED|RID_UNSIGNED) )
	      {
		case RID_SIGNED:
		  sign = "signed";
		  break;
		case RID_UNSIGNED:
		  sign = "unsigned";
		  break;
	      }
	}
    
    return sign;
}

StrTab *make_type_text(Type *t)
{
    char text[2][512];
    int i = 0;
    
    *text[0] = *text[1] = 0;
    
    for( ; t != (Type *)NULL ; t = (Type *)t->link)
      {
	  /* If we have reached a typedef, print the defined name */
	  if ( t->backlink != (void *)NULL) {
/*	      sprintf(text[OTHER(i)], "(%s %s %s)", 
		      sign_text(t),
*/
	      sprintf(text[OTHER(i)], "(%s %s)", 
		      TEXT(((Symbol *)t->backlink)->text), 
		      text[i]), TOGGLE(i);
	      return( allocate_string(text[i]) );
	  }
	  switch( t->tid )
	    {
	      case RID_PTR:
	      case RID_ARRAY:
		sprintf(text[OTHER(i)], "* %s", text[i]), TOGGLE(i);
		break;
	      case RID_FUNC:
		if ( *text[i] == '*' )
		  sprintf(text[OTHER(i)], "(%s)()", text[i]), TOGGLE(i);
		else
		  sprintf(text[OTHER(i)], "%s()", text[i]), TOGGLE(i);
		break;
	      default:
		sprintf(text[OTHER(i)], "(%s %s %s)", 
			sign_text(t), TEXT(t->text), text[i]),
		TOGGLE(i);
		return( allocate_string(text[i]) );
	    }
      }
    
    sprintf(text[OTHER(i)], "(%s int %s)", sign_text(t), text[i]), TOGGLE(i);
    return( allocate_string(text[i]) );
}


StrTab *make_access_mode(Word attributes, char access, 
			 Word incdec, char prepost)
{
    char text[20];
    Word mode = 0;
    
    mode = (Word)access;
    
    if ( attributes & RID_TAGGED )
      mode |= TESTTAG | SETTAG;
    
    if ( attributes & RID_SOFT )
      mode |= SOFT;
    
    if ( incdec )
      mode |= incdec;
    
    if ( prepost == POST )
      mode |= PREVIOUS;
    
    sprintf(text, "0%o", mode);
    
    return( allocate_string(text) );
}


StrTab *make_shared_read(StrTab *addr, Type *t, Word attributes)
{
    char access;
    StrTab *typecast = make_type_text(t);
    StrTab *addrcopy = copy_chain(addr);
    
    switch( SIZE(t) )
      {
	case 1:
	  access = BYTE; break;
	case 2:
	  access = HALFWORD; break;
	case 8:
	  access = DOUBLEWORD; break;
	default:
	  access = WORD;
      }
    
    if ( attributes & RID_TAGACCESS )
      return( link_chain5(allocate_string(READTAG_TEXT),
			  addrcopy,
			  allocate_string(","),
			  make_access_mode(attributes, access, 0, 0),
			  allocate_string(")") ) );
    else
      switch( TID(t) )
	{
	  case RID_FLOAT:
	  case RID_DOUBLE:
	    return(link_chain7(allocate_string("("),
			       typecast,
			       allocate_string(READMEM_FL_TEXT),
			       addrcopy,
			       allocate_string(","),
			       make_access_mode(attributes, access, 0, 0),
			       allocate_string("))") ) );
	  default:
	    return(link_chain7(allocate_string("("),
			       typecast,
			       allocate_string(READMEM_TEXT),
			       addrcopy,
			       allocate_string(","),
			       make_access_mode(attributes, access, 0, 0),
			       allocate_string("))") ) );
	}
}



void primary_ident(Lex *id)
{
    Symbol *s    = (Symbol *)id->tinfo;
    Expr   *expr = newexpr();
    Word   attr  = 0;
    Type   *t;
    
    if ( s == (Symbol *)NULL )  {
	expr->val = id->text;
	expr->addr = (StrTab *)NULL;
	expr->type = (Type *)NULL;
    } else {
	t    = s->type;
	attr = s->attributes;
	  
#ifdef TREEDEBUG
	printf("Got symbol `%s' attributes = %d\n", TEXT(id->text), attr);
#endif
	  
	expr->type = t;
	expr->attributes = attr; 
	
	switch( attr & RID_SHARED ? t->tid : -1 ) {
	  case -1:
	    expr->addr = (StrTab *)NULL;
	    expr->val  = id->text;
	    break;
	  case RID_ARRAY:
	  case RID_STRUCT:
	  case RID_UNION:
	    expr->addr = id->text;
	    expr->val  = copy_string(id->text);
	    break;
	  default:
	    expr->addr = id->text;
	    /* printf("text: %s\n", TEXT(id->text)); */
	    expr->val  =
	      make_shared_read(copy_string(id->text),
			       t, attr);
	}
    }
    
    id->tinfo = (Word)expr;
}



void primary_const(Lex *id)
{
    Expr *expr = newexpr();
    char *status;
    
    expr->addr = (StrTab *)NULL;
    expr->val  = id->text;
    expr->type = (Type *)id->tinfo;
    expr->attributes = 0;
    
    switch( TID(expr->type) )
      {
	case RID_FLOAT:
	case RID_DOUBLE:
	case RID_CHAR:
	  expr->numval = NONUMVAL;
	  break;
	default:
	  expr->numval = strtol(TEXT(id->text), &status, 0);
	  if (expr->numval == 0 && status == TEXT(id->text))
	    expr->numval = NONUMVAL;
      }
    
    id->tinfo = (Word)expr;
}



void primary_string(Lex *id)
{
    Expr *expr = newexpr();
    
    expr->addr = (StrTab *)NULL;
    expr->val  = id->text;
    expr->type = (Type *)id->tinfo;
    expr->attributes = 0;
    
    id->tinfo = (Word)expr;
}




void primary_array(Expr *prim, Lex *left, Expr *expr, Lex *right)
{
    Type *type = prim->type;
    int element_size;
    char offstr[20];
    StrTab *offset;
    
    switch( TID(type) )
      {
	case RID_ARRAY:
	case RID_PTR:
	  element_size = SIZE(((Type *)type->link));
	  if ( element_size <= 0 ) {
	      error("array of or pointer to data type of unknown size");
	      goto free1;
	  }
	  break;
	default:
	  error("subscripted expression is not array or pointer");
	  goto free1;
      }
    
    prim->type = (Type *)type->link;
    
    if ( ! (prim->attributes & RID_SHARED) ) {
	prim->val = link_chain4(prim->val, left->text, expr->val, right->text);
	goto free2;
    }
    
    if ( expr->numval != NONUMVAL ) {
	sprintf(offstr, "+ %d", expr->numval * element_size);
	offset = allocate_string(offstr);
    }
    else {
	sprintf(offstr,"+ (%d * (", element_size);
	offset = link_chain3( allocate_string(offstr),
			     expr->val,
			     allocate_string(") )") );
    }
    
    prim->addr = link_chain4( allocate_string("(__SHARED__)("),
			     prim->val,
			     allocate_string(")"),
			     offset );
    
    
    switch( TID(prim->type) )
      {
	case RID_ARRAY:
	  prim->val = link_chain5(allocate_string("("),
				  make_type_text(prim->type),
				  allocate_string("("),
				  copy_chain(prim->addr),
				  allocate_string("))"));
	  break;
	case RID_STRUCT:
	case RID_UNION:
	  prim->val = copy_chain(prim->addr);
	  break;
	default:
	  prim->val =
	    make_shared_read(prim->addr, prim->type, prim->attributes);
      }
    
  free1:
    free_chain(left->text);
    free_chain(right->text);
  free2:
    free_chain(expr->addr);
    free_expr(expr);
}




void primary_func(Expr *prim, Lex *left, Lex *list, Lex *right)
{
    Type *t = prim->type;
    
    switch ( TID(t) )
      {
	case RID_FUNC:
	  prim->type = (Type *)t->link;
	case NORID:
	  break;
	default:
	  warning("type = %d expression used as function name does not evaluate to a function", TID(t));
	  prim->type = (Type *)NULL;
      }
    
    prim->val = link_chain4(prim->val, left->text, list->text, right->text);
    
    free_chain(prim->addr);
    prim->addr = (StrTab *)NULL;
}



void primary_compound(Expr *prim, Lex *dot, Lex *ident)
{
    char offstr[20];
    Type *type = prim->type;
    Symbol *sym;
    
    switch( TID(type) )
      {
	case RID_STRUCT:
	case RID_UNION:
	  if ( (sym = lookup_component(TEXT(ident->text), type->link))
	      == (Symbol *)NOTFOUND ) {
	      error("structure/union has no component `%s'", TEXT(ident->text) );
	      goto free1;
	  }
	  
	  prim->type = sym->type;
	  
	  if ( ! (prim->attributes & RID_SHARED) ) {
	      prim->val = link_chain3(prim->val, dot->text, ident->text);
	      return;
	  }
	  
	  sprintf(offstr,"+ %d", sym->offset);
	  
	  free_chain(prim->addr);
	  prim->addr = link_chain4(allocate_string("(__SHARED__)("),
				   prim->val,
				   allocate_string(")"),
				   allocate_string(offstr) );
	  
	  
	  switch( TID(prim->type) )
	    {
	      case RID_ARRAY:
		prim->val = link_chain5(allocate_string("("),
					make_type_text(prim->type),
					allocate_string("("),
					copy_chain(prim->addr),
					allocate_string("))"));
		break;
	      case RID_STRUCT:
	      case RID_UNION:
		prim->val = copy_chain(prim->addr);
		break;
	      default:
		prim->val =
		  make_shared_read(prim->addr, prim->type, prim->attributes);
	    }
	  break;
	default:
	  error("request for member `%s' in something not a struct or union",
		TEXT(ident->text) );
      }
    
  free1:
    free_chain(dot->text);
    free_chain(ident->text);
}



void primary_pointsat(Expr *prim, Lex *arrow, Lex *ident)
{
    Type *type = prim->type;
    
    if ( TID(type) != RID_PTR ||
	(TID((Type *)type->link) != RID_STRUCT &&
	 TID((Type *)type->link) != RID_UNION) )
      {
	  error("member `%s' requested of something not a pointer to struct or union", TEXT(ident->text) );
	  free_chain(arrow->text);
	  free_chain(ident->text);
	  return;
      }
    
    prim->type = type->link;
    
    prim->attributes &= ~RID_SHARED;
    
    primary_compound(prim, arrow, ident);
}



void primary_shared_pointsat(Expr *prim, Lex *arrow, Lex *ident)
{
    Type *type = prim->type;
    
    switch ( TID(type) )
      {
	case RID_PTR:
	  prim->type = (Type *)type->link;
	  break;
	default:
	  prim->type = (Type *)NULL;
	  error("@> after something that is not a pointer");
      }
    
    prim->addr = prim->val;
    
    switch( TID(prim->type) )
      {
	case RID_STRUCT:
	case RID_UNION:
	  prim->val = copy_chain(prim->addr);
	  break;
	default:
	  prim->val = copy_chain(prim->addr); /* to prevent infinite loop */
	  error("@> after something that is not a pointer to structure/union");
      }
    
    prim->attributes |= RID_SHARED;
    
    primary_compound(prim, arrow, ident);
}
