
#include <string.h>
#include "cprep.h"
#include "symtable.h"

extern int lineno;
extern FILE *foutput;
extern char *input_filename;

#define SIZE1          8
#define SIZE2          64
#define SIZE3          256

#define MAX_SIZE1      30000
#define MAX_SIZE2      15000
#define MAX_SIZE3      1000

typedef struct strtab1 {
    char status;
    int lineno;
    StrTab *next;
    char text[SIZE1];
} StrTab1;


typedef struct strtab2 {
    char status;
    int lineno;
    StrTab *next;
    char text[SIZE2];
} StrTab2;


typedef struct strtab3 {
    char status;
    int lineno;
    StrTab *next;
    char text[SIZE3];
} StrTab3;



static StrTab1 strtab1[MAX_SIZE1];
static StrTab2 strtab2[MAX_SIZE2];
static StrTab3 strtab3[MAX_SIZE3];

static int nextsize1, nextsize2, nextsize3;

/* String allocation management */

GLOBAL  char last_string_nonempty = FALSE;

static void string_fout(FILE *f, StrTab *s)
{
    char c, *p = (char *)&s->text;
    
    while( c = *p++ )
      {
	  last_string_nonempty = TRUE;
	  putc(c, f);
      }
}


static StrTab *newstr1()
{
    int i, sid;
    
    for(i=0; i<MAX_SIZE1; i++) {
	if ( (sid = nextsize1--) <= 0)
	  nextsize1 = MAX_SIZE1-1;
	if (strtab1[sid].status == EMPTY)
	  return( (StrTab *)&strtab1[sid] );
    }
    
#ifdef STRDEBUG
    fprintf(stderr, "newstr1 failed.\n");
#endif
    
    return( (StrTab *)NULL );
}


static StrTab *newstr2()
{
    int i, sid;
    
    for(i=0; i<MAX_SIZE2; i++) {
	if ( (sid = nextsize2--) <= 0)
	  nextsize2 = MAX_SIZE2-1;
	if (strtab2[sid].status == EMPTY)
	  return( (StrTab *)&strtab2[sid] );
    }
    
    
#ifdef STRDEBUG
    fprintf(stderr, "newstr2 failed.\n");
#endif
    
    return( (StrTab *)NULL );
}

static StrTab *newstr3()
{
    int i, sid;
    
    for(i=0; i<MAX_SIZE3; i++) {
	if ( (sid = nextsize3--) <= 0)
	  nextsize3 = MAX_SIZE3-1;
	if (strtab3[sid].status == EMPTY)
	  return( (StrTab *)&strtab3[sid] );
    }
    
    
#ifdef STRDEBUG
    fprintf(stderr, "newstr3 failed.\n");
#endif
    
    return( (StrTab *)NULL );
}



GLOBAL StrTab *allocate_string(char *s)
{
    int len = strlen(s);
    StrTab *sptr;
    
    if ( len < SIZE1 ) {
	if ( ( sptr = newstr1()) == (StrTab *)NULL )
	  goto size2;
    } else if (len < SIZE2 ) {
      size2: 
	if ( ( sptr = newstr2()) == (StrTab *)NULL )
	  goto size3;
    } else if ( len < SIZE3 ) {
      size3:
	if ( ( sptr = newstr3()) == (StrTab *)NULL )
	  goto abort;
    } else {
	fprintf(stderr, "token too large (max.size = %d)\n", SIZE3);
	goto abort;
    }
    
    sptr->status = FULL;
    sptr->lineno = lineno;
    sptr->next = (StrTab *)NULL;
    strcpy((char *)&sptr->text, s);
    return sptr;

  abort:
    fprintf(stderr, "string=(%s)\n", s);
    fatal("out of string space");
    /* unreachable */
    return NULL;
}


GLOBAL int free_string(StrTab *sptr)
{
    
    if ( sptr->status == EMPTY )
      return(ERROR);
    
    sptr->status = EMPTY;
    sptr->next = (StrTab *)NULL;
    return(OK);
}


GLOBAL int free_chain(StrTab *sptr)
{
    StrTab *next;
    
    if ( sptr == (StrTab *)NULL )
      return(ERROR);
    
    for(;; sptr = next) {
	next = sptr->next;
	if (free_string(sptr) == ERROR) return(ERROR);
	if (next == (StrTab *)NULL) return(OK);
    }
    /* unreachable */
}


int debug_string = 0;

static void CheckForLoop(StrTab *s)
{
    StrTab *p; int i;

    if (s == NULL) return;

    for (p=s->next, i=1; p != NULL; p = p->next, i++)
      if (p == s) {
	  string_fout(stdout, s), putc(' ', stdout);
	  for (p=s->next; p != s; p = p->next)
	    string_fout(stdout, p), putc(' ', stdout);
	  putchar('\n');
	  fatal("Loop in StrTab starting at 0x%x, length=%d\n", s, i);
      }
    return;
}

StrTab *link_chain2(StrTab *s, StrTab *p)
{
    StrTab *sorig = s;
    
    while (s->next != NULL) s = s->next;
    s->next = p;
    
    if (debug_string) CheckForLoop(s);
    return(sorig);
}


StrTab *link_chain3(StrTab *s, StrTab *p, StrTab *q)
{
    (void)link_chain2(p,q);
    return(link_chain2(s,p));
}


StrTab *link_chain4(StrTab *s, StrTab *p, StrTab *q, StrTab *r)
{
    (void)link_chain2(q,r);
    (void)link_chain2(p,q);
    return(link_chain2(s,p));
}


StrTab *link_chain5(StrTab *s, StrTab *p, StrTab *q, StrTab *r, StrTab *t)
{
    
    (void)link_chain2(r,t);
    (void)link_chain2(q,r);
    (void)link_chain2(p,q);
    return(link_chain2(s,p));
}


StrTab *link_chain6(StrTab *s, StrTab *p, StrTab *q, StrTab *r, StrTab *t,
		    StrTab *u)
{
    
    (void)link_chain2(t,u);
    (void)link_chain2(r,t);
    (void)link_chain2(q,r);
    (void)link_chain2(p,q);
    return(link_chain2(s,p));
}


StrTab *link_chain7(StrTab *s, StrTab *p, StrTab *q, StrTab *r, StrTab *t,
		    StrTab *u, StrTab *v)
{
    
    (void)link_chain2(u,v);
    (void)link_chain2(t,u);
    (void)link_chain2(r,t);
    (void)link_chain2(q,r);
    (void)link_chain2(p,q);
    return(link_chain2(s,p));
}

StrTab *link_chain8(StrTab *s, StrTab *p, StrTab *q, StrTab *r, StrTab *t,
		    StrTab *u, StrTab *v, StrTab *w)
{
    
    (void)link_chain2(v,w);
    (void)link_chain2(u,v);
    (void)link_chain2(t,u);
    (void)link_chain2(r,t);
    (void)link_chain2(q,r);
    (void)link_chain2(p,q);
    return(link_chain2(s,p));
}

StrTab *link_chain9(StrTab *s, StrTab *p, StrTab *q, StrTab *r, StrTab *t,
		    StrTab *u, StrTab *v, StrTab *w, StrTab *x)
{
    (void)link_chain2(w,x);
    (void)link_chain2(v,w);
    (void)link_chain2(u,v);
    (void)link_chain2(t,u);
    (void)link_chain2(r,t);
    (void)link_chain2(q,r);
    (void)link_chain2(p,q);
    return(link_chain2(s,p));
}

static int out_lineno = 0;


void out_chain(StrTab *s)
{
    int previous;
    
    last_string_nonempty = FALSE;
    
    for( ; s != (StrTab *)NULL; s = s->next) {
	if ( s->lineno != (previous = out_lineno) ) {
	    out_lineno = s->lineno;
	    if ( out_lineno != previous+1 )
	      fprintf(foutput,"\n# %d \"%s\"\n", out_lineno, input_filename);
	    else
	      putc('\n',foutput);
	}
	string_fout(foutput, s), putc(' ', foutput);
	
	s->status = EMPTY;
    }
}



StrTab *copy_string(StrTab *s)
{
    return( allocate_string( TEXT(s) ) );
}



StrTab *copy_chain(StrTab *s)
{
    StrTab *head, *new;
    
    if (s == (StrTab *)NULL)
      return((StrTab *)NULL);
    
    head = new = copy_string( s );
    
    for(s = s->next; s != (StrTab *)NULL; 
	new = new->next, s = s->next) {
	new->next  = copy_string(s);
    }
    
    return( head );
}



void init_strings()
{
}


void print_chain(StrTab *s)
{
    last_string_nonempty = FALSE;
    
    printf("CHAIN: ");
    for( ; s != (StrTab *)NULL; s = s->next) {
	string_fout(stdout, s), putc(' ', stdout);
    }
    printf("\n");
}
