/****************************************************************************
 *                                                                          *
 *                     Parallel Architecture Simulator                      *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module:
 *                                                                          *
 * Description:
 *                                                                          *
 * Last Modified:
 *                                                                          *
 * Data Structures:
 *                                                                          *
 * Constants:
 *                                                                          *
 * Variables:
 *                                                                          *
 ****************************************************************************/


typedef struct strtab {
                      char status;
		      int lineno;
		      struct strtab *next;
		      char *text;
		    } StrTab;



typedef struct ttype {
                      char level;
                      Word   tid;
		      StrTab *text;
		      Word   typequals;
 		      int    size;
		      int    totelem;
		      void   *link;
		      void   *backlink;
		    } Type;



typedef struct symb {
                      char level;
                      StrTab *text;
		      Word class;
		      Word attributes;
		      int offset;
		      int processor;
		      Type *type;
		      struct symb *left, *right;
		    } Symbol;



typedef struct {
                StrTab *text;
		Word   tinfo;
	      } Lex;


typedef struct {
                 Type *type;
		 Word typequals;
		 Word attributes;
		 char components;
		 char parameters;
	       } Decl;


typedef struct {
                 char status;
                 StrTab *addr;
		 StrTab *val;
		 Type   *type;
		 Word   attributes;
                 long    numval;
	       } Expr;



extern char  error_flag, xdecls_flag;
extern char profile_flag, insert_stmt_flag;

extern Decl *currdecl;

extern Symbol *tree_stack[];
extern Symbol **currtree;

extern FILE *finput, *foutput, *finitmem, *fipic;

extern char *input_filename;

extern char last_string_nonempty;

extern int curr_tree_level;

extern StrTab *int_text, *char_text, *float_text, *double_text, *short_text,
       *long_text, *void_text;

extern int TREELEVEL;



/* function prototypes */

StrTab *link_chain2();
StrTab *link_chain3();
StrTab *link_chain4();
StrTab *link_chain5();
StrTab *link_chain6();
StrTab *link_chain7();
StrTab *link_chain8();
StrTab *link_chain9();

Lex lookup_structure(Lex *sym, int create);
Lex lookup_union();
Lex lookup_enum();
Lex empty_lex();

int free_chain(StrTab *text);
void out_chain(StrTab *s);
StrTab *empty_string();
StrTab *copy_string();
StrTab *copy_chain();
StrTab *allocate_string();

void out1(Lex *l);
void out2(Lex *l1, Lex *l2);
void out3(Lex *l1, Lex *l2, Lex *l3);
void out4(Lex *l1, Lex *l2, Lex *l3, Lex *l4);
void out5(Lex *l1, Lex *l2, Lex *l3, Lex *l4, Lex *l5);
void outs(char *s);
void outid(Lex *l);
void outnl();
void outgetmem(Lex *s);

void unary_star(Lex *star, Expr *expr);
void unary_at(Lex *at, Expr *expr);
void unary_op(Lex *op, Lex *e);
void unary_sizeof(Lex *sizof, Expr *expr);
void unary_sizeof_typename(Lex *sizof, Lex *left, Lex *typenam, Lex *right);
void unary_tag(Lex *tag, Expr *expr);

void make_binary_expression(int opcode, Lex *e1,
                            Lex *op, Lex *e2, Bool freeflag);
void make_conditional_expression(Lex *e1, Lex *thn, Lex *e2,
                                 Lex *els, Lex *e3);
void make_assignment(Lex *e1, Lex *op, Lex *e2, char prepost);
void make_abbreviated_assignment( Lex *e1, Lex *op, Lex *e2, char prepost);
void make_increment_decrement(Lex *e, Lex *op, char prepost);
void update_numval(int opcode, Expr *op1, Expr *op2);
long eval(Expr *e);

int insert_symbol(Symbol *sym, Symbol **tree);

StrTab *make_shared_read();
StrTab *make_access_mode(Word attributes, char access, 
			 Word incdec, char prepost);

Symbol *lookup_symbol_rec();
Symbol *lookup_component();

Type *insert_pointer(Type *t);

void pushlevel_tree();
void poplevel_tree();
void free_curr_tree(Symbol *symbol);
void free_type(Type *type);
void pushlevel_decl();
void poplevel_decl();
void reset_decl();

void ipi_statement(Lex *name, Lex *code, Lex *handler);

char *sign_text(Type *t);
StrTab *make_type_text(Type *t);
StrTab *make_access_mode(Word attributes, char access,
                         Word incdec, char prepost);
StrTab *make_shared_read(StrTab *addr, Type *t, Word attributes);
void primary_ident(Lex *id);
void primary_const(Lex *id);
void primary_string(Lex *id);
void primary_array(Expr *prim, Lex *left, Expr *expr, Lex *right);
void primary_func(Expr *prim, Lex *left, Lex *list, Lex *right);
void primary_compound(Expr *prim, Lex *dot, Lex *ident);
void primary_pointsat(Expr *prim, Lex *arrow, Lex *ident);
void primary_shared_pointsat(Expr *prim, Lex *arrow, Lex *ident);

void identifier_decl(Lex *lex);
void pointer_decl(Lex *star, Lex *rest);
void pointer_type_decl(Lex *star, Lex *rest);
void array_decl(Lex *rest, Lex *left, Lex *expr, Lex *right);
void array_type_decl(Lex *rest, Lex *left, Lex *expr, Lex *right);
void empty_array_decl(Lex *rest, Lex *left, Lex *right);
void empty_array_type_decl(Lex *rest, Lex *left, Lex *right);
void func_decl(Lex *rest, Lex *left, Lex *parms);
void func_type_decl(Lex *rest, Lex *left, Lex *parms);
void make_empty_structure(Lex *name);
void fill_structure(Lex *name, Lex *components);
void make_empty_union(Lex *name);
void fill_union(Lex *name, Lex *components);
void make_enum(Lex *name);
void insert_enum_ident(Lex *name);
void link_components(Lex *l1, Lex *l2);
void new_scspec(Lex *lex);
void add_scspec(Lex *rest, Lex *new);
void new_typequal(Lex *lex);
void add_typequal(Lex *rest, Lex *new);
void placement_directive(Lex *s, Lex *where);
Lex new_internal_name();
Expr *make_expr(Lex *name);

Symbol *newsymbol();
Type *newtype();
Expr *newexpr();
void free_expr(Expr *e);
void print_symbol(Symbol *);
void print_type(Type *);
void print_chain(StrTab *);
extern int sym_debug;
