
#include "cprep.h"
#include "symtable.h"

#define MAX_SYMBOLS           10000
#define MAX_TYPES             30000
#define MAX_EXPRS             15000

static Symbol symboltab[MAX_SYMBOLS];
static Type   typetab[MAX_TYPES];
static Expr   exprtab[MAX_EXPRS];

extern int curr_tree_level;

static int nextsym = 0;

void init_symbols()
{
}

Symbol *newsymbol()
{
    int i, sid;
    Symbol *sptr;
    
    for(i=0; i<MAX_SYMBOLS; i++) {
	if( (sid = nextsym--) <= 0 )
	  nextsym = MAX_SYMBOLS-1;
	if( symboltab[sid].level <= 0) {
	    (sptr = &symboltab[sid])->level = curr_tree_level;
	    sptr->left = sptr->right = (Symbol *)NULL;
	    return( sptr );
	}
    }
    
    fatal("cannot allocate new symbol -- increase size of symboltab");
    /* unreachable */
    return NULL;
}


static int nexttyp = 0;

void init_types()
{
}

Type *newtype()
{
    int i, tid;
    Type *tptr;
    
    for(i=0; i<MAX_TYPES; i++) {
	if( (tid = nexttyp--) <= 0 )
	  nexttyp = MAX_TYPES-1;
	if( typetab[tid].level <= 0 ) {
	    (tptr = &typetab[tid])->level = curr_tree_level;
	    tptr->link = tptr->backlink = (void *)NULL;
	    if (sym_debug) {
		printf("newtype: tid=%d, tptr=0x%lx\n", tid, (long)tptr);
	    }
	    return( tptr );
	}
    }
    
    fatal("cannot allocate new type -- increase size of typetab");

    /* unreachable */
    return NULL;
}


static int nextexpr = 0;

void init_exprs()
{
}

Expr *newexpr()
{
    int i, eid;
    Expr *eptr;
    
    for(i=0; i<MAX_EXPRS; i++) {
	if( (eid = nextexpr--) <= 0 )
	  nextexpr = MAX_EXPRS-1;
	if( (eptr = &exprtab[eid])->status == EMPTY ) {
	    eptr->status = FULL;
	    eptr->addr = eptr->val = (StrTab *)NULL;
	    eptr->type = (Type *)NULL;
	    eptr->attributes = 0;
	    eptr->numval = NONUMVAL;
	    return( eptr );
	}
    }
    
    fatal("cannot allocate new expr -- increase size of exprtab");

    /* unreachable */
    return NULL;
}


void free_expr(Expr *e)
{
    e->status = EMPTY;
}
