
#include "cprep.h"
#include "symtable.h"

#define MAX_TREE_LEVEL              12

Symbol *tree_stack[MAX_TREE_LEVEL];
Symbol **currtree;
int curr_tree_level;

GLOBAL void init_tree()
{
    curr_tree_level = 1;
    currtree = &tree_stack[1];
}


GLOBAL void pushlevel_tree()
{
    curr_tree_level++;
    
#ifdef TREEDEBUG
    printf("\nPushing tree level to %d\n", curr_tree_level);
#endif
    
    if ( curr_tree_level >= MAX_TREE_LEVEL )
      fatal("too many nested blocks (max. %d)", MAX_TREE_LEVEL);
    
    currtree++;
    *currtree = (Symbol *)NULL;
}


GLOBAL void poplevel_tree()
{
    if ( curr_tree_level <= 1 )
      fatal("symbol tree stack underflow -- this is an internal error");
    
#ifdef TREEDEBUG
    printf("\nPopping tree from level %d to %d\n", curr_tree_level, curr_tree_level-1);
#endif
    
    free_curr_tree(*currtree);
    curr_tree_level--;
    currtree--;
    
    SAVEPARMS_FLAG = FALSE;
}


GLOBAL void free_curr_tree(Symbol *symbol)
{
    if (symbol == (Symbol *)NULL)
      return;
    if (symbol->level != curr_tree_level)
      return;
    
#ifdef FREEDEBUG
    printf("Freeing symbol `%s'\n", TEXT(symbol->text) );
    printf("sym->level=%d, sym->type->level=%d\n",
	   symbol->level,
	   symbol->type != NULL ? symbol->type->level : -1);
#endif
    
    free_chain(symbol->text);
    free_type(symbol->type);
    
    free_curr_tree(symbol->left);
    free_curr_tree(symbol->right);
    
    symbol->level = 0;
}


extern Symbol *the_sym;
extern int lineno;

GLOBAL void free_type(Type *type)
{
    if (type == NULL) return;

    if (type->level >= curr_tree_level) {
	
	free_chain(type->text);
	
	switch( type->tid )
	  {
	    case RID_STRUCT:
	    case RID_UNION:
	      free_curr_tree(type->link);
	      break;
	    default:
	      free_type(type->link);
	  }
	type->level = 0;
    }
}



/*===========================================================================
 * Decl stack
 *===========================================================================
 */

#define MAX_DECL_LEVEL            12

Decl decl_stack[MAX_DECL_LEVEL];

Decl *currdecl;

int curr_decl_level;


GLOBAL void init_decl()
{
    curr_decl_level = 0;
    currdecl = decl_stack;
}


GLOBAL void pushlevel_decl()
{
    curr_decl_level++;
    
    if ( curr_decl_level >= MAX_DECL_LEVEL )
      fatal("decl stack overflow -- too many nested declarations");
    
    currdecl++;
    
    reset_decl();
}


GLOBAL void poplevel_decl()
{
    if ( curr_decl_level == 0 )
      fatal("decl stack underflow -- this is an internal error");
    
    curr_decl_level--;
    currdecl--;
}


GLOBAL void reset_decl()
{
    Type *tptr;
    
    if (xdecls_flag)
      return;
    
    currdecl->typequals  = 0;
    currdecl->attributes = 0;
    currdecl->components = FALSE;
    currdecl->parameters = FALSE;
    
    tptr = newtype();
    
    tptr->tid = RID_INT;
    tptr->text = copy_string(int_text);
    tptr->size = SIZE_INT;
    currdecl->type = tptr;
}
