/*
 * Assembly code to cuase context switch to simulator when quantum expires.
 * Eric A. Brewer
 * 5-24-90
 * 
 * $Header: /psg/proteus/RCS/SimQuantum.S,v 1.8 92/12/13 18:41:14 brewer Exp $
 * $Log:	SimQuantum.S,v $
 * Revision 1.8  92/12/13  18:41:14  brewer
 * Added room for argument build area in stack allocation for SimQuantum
 * and for SimStack.
 * 
 * Revision 1.7  92/09/23  12:32:25  brewer
 * (changed name from SimQuantum.s to SimQuantum.S)
 * 
 * Revision 1.6  92/04/01  17:14:02  brewer
 * changed RCS comment char to " * "
 * 
 * Revision 1.5  92/04/01  17:11:08  brewer
 * changed to use C-style comments
 * 
 * Revision 1.4  92/02/13  15:48:07  brewer
 * edited r1.3 log message
 * 
 * Revision 1.3  92/02/12  16:46:39  brewer
 * Changed RCS comment char to " * "
 * 
 * Revision 1.2  92/02/11  17:37:16  brewer
 * Fixed header, log messages
 *
 * Revision 1.1  92/02/11  16:07:20  brewer
 * Initial revision
 *
 */

	.globl	expired_	# quantum expired flag
	.globl	cycles_		# cycle counter
	.globl	currtptr	# current thread pointer
	.globl	sim_regs_	# registers for simulator thread
.text
	.align 2
	.globl	SimQuantum
	.ent	SimQuantum
SimQuantum:
	subu	$sp, 24		# add 24 instead of 20 to account for
	sw	$4, 8($sp)	#   $31 saved before call to SimQuantum
	sw	$5, 12($sp)	# save registers $4, $5, and $31
 	sw	$31, 16($sp)
	.mask	0x80000030, -8
	.frame	$sp, 24, $31
	li	$4, 1		# set "quantum expired" flag
	sw	$4, expired_

	lw	$4, currtptr	# ctxsw(currptr, &sim_regs_)
	la	$5, sim_regs_
	jal	full_ctxsw

	lw	$4, 8($sp)	# restore registers
	lw	$5, 12($sp)
 	lw	$31, 16($sp)

	addu	$sp, 24		# restore stack pointer
	j	$31
 	.end	SimQuantum

.data
$LC0:
	.ascii	"Stack Overflow\12\0"
.text
	.align 2
	.globl	SimStack
	.ent	SimStack
SimStack:
  	subu	$sp, 24
	sw	$31, 20($sp)
	.mask	0x80000000, -4
	.frame	$sp, 24, $31
	la	$4, $LC0
	jal	fatal
	lw	$31, 20($sp)
	addu	$sp, 24	
	j	$31
	.end	SimStack

