/***************************************************************************
 *
 * File common to various sub-systems, including proteus and
 * the events library.
 *
 ***************************************************************************
 *
 * $Header: /usr/wildcat/dfk/research/parallel/proteus/proteus-V3.01/engine/RCS/common.h,v 1.1 94/01/27 00:52:44 dfk Exp Locker: dfk $
 *
 * $Log:	common.h,v $
 * Revision 1.1  94/01/27  00:52:44  dfk
 * Initial revision
 * 
 *
 \**************************************************************************/


#ifndef _COMMON_H
#define _COMMON_H

/*
 * remove const keyword for cc2.1
 */
#ifndef __STDC__
#define const
#endif

/*
 * "GLOBAL" is used as a keyword to indentify global variables
 */
#define GLOBAL

/*
 * LIBRARY marks prototypes for procedures in various C libraries
 */
#define LIBRARY extern

/*
 * comment out `inline' if not gcc
 */
#ifndef __GNUC__
#define inline
#endif

#ifndef _CA_			/* if not a .ca file, ignore cycle counting stuff */
#define CYCLE_COUNTING_ON
#define CYCLE_COUNTING_OFF
#endif _CA_

/*
 * UNREACHABLE() assertion
 */
#ifdef __FILE__
#ifdef __LINE__

#define UNREACHABLE() \
  fatal("At \"UNREACHABLE()\" in file \"%s\", line %d\n", __FILE__, __LINE__)

#else /* __LINE__ not defined */
#define UNREACHABLE() \
  fatal("At \"UNREACHABLE()\" in file \"%s\"\n", __FILE__)
#endif /* __LINE__ */
#else /* __FILE__ not defined */
#define UNREACHABLE() \
  fatal("At \"UNREACHABLE()\"\n")
#endif /* __FILE__ */

/*
 * Common constants.
 */
#define ERROR             -1
#define OK                 0
#ifndef FALSE
#define FALSE              0
#endif
#ifndef TRUE
#define TRUE               1
#endif
#define BOOL               char

/*
 * Time type
 */

/* Uncomment following line to get bigger time counters with GCC */
#define LONG_LONG_TIME

#if (!defined(__GNUC__) && defined(LONG_LONG_TIME))
#error Long time counters are only available with GCC
#endif

#ifdef LONG_LONG_TIME
typedef unsigned long long int Time;
#else
typedef unsigned long Time;
#endif

/*
 * Other common types.
 */
typedef unsigned long      ulong;

/*
 * Library procedures
 */

#ifdef __STDC__
LIBRARY void fatal(const char *format, ...);
LIBRARY void bzero(char *pointer, int length);
LIBRARY void bcopy(char *src, char *dest, int length);
LIBRARY char* time_print(Time time);

LIBRARY void srandom(int seed);
LIBRARY long random(void);

LIBRARY int fsync(int fd);
LIBRARY long tell(int fd);

#else

LIBRARY void fatal();
LIBRARY void bzero();
LIBRARY void bcopy();
LIBRARY char* time_print();

LIBRARY void srandom();
LIBRARY long random();

LIBRARY int fsync();
LIBRARY long tell();

#endif /* __STDC__ */


#endif /* _COMMON_H */
