 /****************************************************************************
 *
 *                     Parallel Architecture Simulator  
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science  
 *                  Massachusetts Institute of Technology
 *
 * Module: conf.h -- Configuration header file
 *
 * Description: conditional macros
 *
 * Last Modified: $Date: 92/09/24 12:04:57 $ ($Author)
 *
 * Data Structures: none
 *
 * Constants: none
 *
 * Macros:
 *     EVENT_IDLE(time, proc)
 *     EVENT_BUSY(time, proc)
 *     EVENT_START_THREAD(time, tid)
 *     EVENT_KILL_THREAD(time, tid)
 *
 ***************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ***************************************************************************
 * $Header: /psg/proteus/RCS/conf.h,v 1.3 92/09/24 12:04:57 brewer Exp $
 * $Log:	conf.h,v $
 * Revision 1.3  92/09/24  12:04:57  brewer
 * Added ifndef at the top
 * 
 * Revision 1.2  92/04/28  11:22:08  brewer
 * Added include file event.h
 * Changed definition of EVENT_BUSY to have a value=1.
 * 
 * Revision 1.1  92/02/11  14:19:26  brewer
 * Initial revision
 * 
 \**************************************************************************/

#ifndef _CONF_H_
#define _CONF_H_

#include "conf.param"

#include "event.h"

#ifdef WATCH_IDLE
#define EVENT_IDLE(time, proc) \
  ATEVENT(EV_IDLE, MAKE_SHORT_INDEX(proc), time)
/* set value for EV_BUSY to 1 */
#define EVENT_BUSY(time, proc) \
  ATEVENT(EV_BUSY | 1, MAKE_SHORT_INDEX(proc), time)

#else
#define EVENT_IDLE(time, proc)
#define EVENT_BUSY(time, proc)
#endif

#ifdef WATCH_THREADS
#define EVENT_START_THREAD(time, tid) \
  ATEVENT(EV_START_THREAD, SHORT_VALUE(tid), time)
#define EVENT_KILL_THREAD(time, tid) \
  ATEVENT(EV_END_THREAD, SHORT_VALUE(tid), time)
#else
#define EVENT_START_THREAD(time, tid)
#define EVENT_KILL_THREAD(time, tid)
#endif

#endif /* ifndef _CONF_H_ */
