
/**************************************************************************\
 *                                                                          *
 *                 Proteus Parallel-Architecture Simulator                  *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module: fatal.c                                                          *
 *                                                                          *
 * Description: Fatal error handler                                         *
 *                                                                          *
 * Last Modified:  6-4-91  (eab)                                            *
 *                                                                          *
 * Global Functions:                                                        *
 *     void fatal(char *format, arg1, arg2, ..., arg6)                      *
 *                                                                          *
 * Global Variables: none                                                   *
 *                                                                          *
 ****************************************************************************
 *   Copyright 1991                                                         *
 *   Eric A. Brewer  and  Chris N. Dellarocas                               *
 *   Massachusetts Institute of Technology                                  *
 *                                                                          *
 *   Permission to use, copy, modify, and distribute this program           *
 *   for any purpose and without fee is hereby granted, provided            *
 *   that this copyright and permission notice appear on all copies         *
 *   and supporting documentation, the name of M.I.T. not be used           *
 *   in advertising or publicity pertaining to distribution of the          *
 *   program without specific prior permission, and notice be given         *
 *   in supporting documentation that copying and distribution is           *
 *   by permission of M.I.T.  M.I.T. makes no representations about         *
 *   the suitability of this software for any purpose.  It is pro-          *
 *   vided "as is" without express or implied warranty.		            *
 ****************************************************************************
 * $Header: /usr/zealand1/dfk/research/parallel/proteus/current/engine/RCS/fatal.c,v 1.2 1996/09/17 21:52:12 dfk Exp $
 * $Log: fatal.c,v $
 * Revision 1.2  1996/09/17 21:52:12  dfk
 * added fflush(stdout) to fatal()
 *
 * Revision 1.1  1996/09/17 21:51:26  dfk
 * Initial revision
 *
 * Revision 1.6  92/12/09  15:16:08  brewer
 * updated calls to trace_stack
 * 
 * Revision 1.5  92/11/08  14:57:53  brewer
 * Add fprintf for processor and thread id.
 * Removed abort_on_fatal_ check (now inside snapshot).
 * 
 * Revision 1.4  92/09/23  11:56:27  brewer
 * Updated args to trace_stack_
 * Added fatal_regs array
 * 
 * Revision 1.3  92/06/25  13:08:10  brewer
 * Added support for "abort on fatal error" option
 * 
 * Revision 1.2  92/03/09  14:23:15  brewer
 * Updated to use ANSI variable-length argument lists (stdarg.h)
 * 
 * Revision 1.1  92/02/11  13:55:36  brewer
 * Initial revision
 * 
 \**************************************************************************/

#include <stdio.h>
#include "sim.h"
#include "conf.h"
#include "thread.h"

extern GLOBAL int currtid;              /* Id of current thread */
extern BOOL abort_on_fatal_; /* declared and set in main.c */
static int in_fatal = 0;
static unsigned long fatal_regs[32];
extern void GetRegs(unsigned long registers[32]);

#ifdef __STDC__
#include <stdarg.h>

GLOBAL void fatal(const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);

    fflush(stdout);

    fprintf(stderr, "Fatal Error: ");
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n\n");
    
    if (mode_ == USER)
      fprintf(stderr, "Processor: %d   Thread: %d = %d:%d\n\n",
	      processor_, currtid, processor_, MY_TID);

    if (!in_fatal) {
      in_fatal = 1;
      /* show stack where fatal error occurred */
      bzero((void *)fatal_regs, 32*sizeof(ulong));
      GetRegs(fatal_regs);
      trace_stack_(stderr, fatal_regs[31], fatal_regs, currtid);
    }

    snapshot();
    
    exit(1);

    va_end(ap);
}

#else /* assume Ultrix cc compiler */
#include <varargs.h>

GLOBAL void fatal(va_alist)
    va_dcl
{
    va_list ap;

    va_start(ap);

    fflush(stdout);

    fprintf(stderr, "Fatal Error: ");
    vfprintf(stderr, va_arg(ap, const char *), ap);
    fprintf(stderr, "\n\n");
    
    if (!in_fatal) {
      in_fatal = 1;
      /* show stack where fatal error occurred */
      bzero((void *)fatal_regs, 32*sizeof(ulong));
      GetRegs(fatal_regs);
      trace_stack_(stderr, fatal_regs[31], fatal_regs, currtid);
    }

    snapshot();
    
    exit(1);

    va_end(ap);
}

#endif /* __STDC__ */
