
 /**************************************************************************\
 *
 *                 Proteus Parallel-Architecture Simulator
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science
 *                  Massachusetts Institute of Technology
 *
 * Module: net.c
 *
 * Description:
 *         Network module. Receives packets, introduces appropriate delay
 *         and delivers them to the destination node.
 *
 * Last Modified:  6-12-91  (eab)
 *
 * Global Functions: none (see included files)
 *
 * Global Variables: none (see included files)
 *
 ****************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ****************************************************************************
 * $Header: /psg/proteus/RCS/net.c,v 1.1 92/02/11 13:56:00 brewer Exp $
 * $Log:	net.c,v $
 * Revision 1.1  92/02/11  13:56:00  brewer
 * Initial revision
 * 
 \**************************************************************************/

#include "sim.h"
#include "conf.h"
#include "rt_thread_def.h"
#include "net.h"

#ifdef NET

#ifdef NET_EXACT

#ifdef ALEWIFE
#include "alewife.exact_net.c"
#else
#include "net.exact.c"
#endif /* ALEWIFE */

#else

#ifdef ALEWIFE
#include "alewife.model_net.c"
#else
#include "net.model.c"
#endif /* ALEWIFE */

#endif /* NET_EXACT */

#endif /* NET */
