
 /**************************************************************************\
 *
 *                 Proteus Parallel-Architecture Simulator
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science
 *                  Massachusetts Institute of Technology
 *
 * Module: net.h
 *
 * Description: Structures, definitions and constants for network module
 *
 * Last Modified: $Date ($Author)
 *
 * Data Structures: none
 *
 * Constants:
 *     NETWINDOW
 *     MAX_CHAN_UTIL
 *     CHAN_UTIL_FACTOR
 *     CONTENTION_FACTOR
 *     RESUME_CALLER
 *     COMPLETE
 *     NO_OF_LINES
 *     Kd
 *     
 * Referenced parameters:
 *     Nk
 *     Ndim
 *     N_DIRECT
 *     N_INDIRECT
 *     N_BIDIR
 *     N_UNIDIR
 *
 * Macros:
 *     InvalidChan(c)
 *
 ****************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ***************************************************************************
 * $Header: /usr/wildcat/dfk/research/parallel/proteus/proteus-V3.01/engine/RCS/net.h,v 1.2 94/01/27 01:19:45 dfk Time64bit $
 * $Log:	net.h,v $
 * Revision 1.2  94/01/27  01:19:45  dfk
 * Needed to change floats to doubles
 * to workaround a gcc bug where you can't do arithmetic
 * that mixes floats with long longs
 * 
 * Revision 1.1  94/01/27  01:02:38  dfk
 * Initial revision
 * 
 * Revision 1.2  92/09/24  12:05:36  brewer
 * Added ifndef at the top
 * 
 * Revision 1.1  92/02/11  14:19:51  brewer
 * Initial revision
 * 
 \**************************************************************************/

#ifndef _NET_H_
#define _NET_H_

#include "net.param"

#define NETWINDOW               ((double)100)
#define MAX_CHAN_UTIL           .9

#ifdef  N_DIRECT

#ifdef  N_UNIDIR
#define Kd                      (((double)(Nk - 1))/2)
#endif
#ifdef  N_BIDIR
#define Kd                      (((double)Nk)/4)
#endif

#define CHAN_UTIL_FACTOR        Kd
#define CONTENTION_FACTOR       (Kd*(1/(Kd+1)+1/(Ndim*Kd))/(Kd+1))

#endif

#ifdef  N_INDIRECT
#define Kd                      ((double)Nk)
#define CONTENTION_FACTOR       ((double)(1-1/Kd)/2)
#define CHAN_UTIL_FACTOR        1
#endif

/* network flags for send_request */
#define RESUME_CALLER    1
#define COMPLETE         0x10000    /* cause a "send complete" interrupt */


/* Accurate network simulation */

#ifdef N_BIDIR
#define NO_OF_LINES      (Nk > 2 ? 2*Ndim : Ndim)
#endif
#ifdef N_UNIDIR
#define NO_OF_LINES      Ndim
#endif

#define InvalidChan(c)         (((c)<0)||((c)>=NO_OF_LINES))

#endif /* #ifndef _NET_H_ */
