
 /**************************************************************************\
 *
 *                 Proteus Parallel-Architecture Simulator
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science
 *                  Massachusetts Institute of Technology
 *
 * Module: packet.h
 *
 * Description: Structures, definitions and constants for packet module
 *
 * Last Modified: $Date: 92/11/19 14:19:40 $ ($Author)
 *
 * Data Structures: Packet structures
 *
 * Constants:
 *     CTOM_PKT
 *     MTOC_PKT  
 *     NOCACHE_PKT
 *     PKT_IPI 
 *     PKT_MEM 
 *
 * Referenced parameters: MAX_PACKET_WORDS
 *
 * Macros: none
 *
 ****************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ***************************************************************************
 * $Header: /psg/proteus/RCS/packet.h,v 1.5 92/11/19 14:19:40 brewer Exp $
 * $Log:	packet.h,v $
 * Revision 1.5  92/11/19  14:19:40  brewer
 * Changed interface to build_new_packet_ to use stdarg convention.
 * Added support for SEND_RECEIVE communication model.
 * 
 * Revision 1.4  92/11/13  16:35:53  brewer
 * Replaced dispatch_processor and dispatch_controller with
 * dispatch_packet_.
 * 
 * Revision 1.3  92/09/24  12:05:57  brewer
 * Added ifndef at the top
 * 
 * Revision 1.2  92/08/24  12:45:00  brewer
 * Added prototype for build_new_packet_
 * Changed packet_handler array to static from GLOBAL
 * Removed constants P_FREE and P_FULL that were previously used
 * for packet memory management.
 * Changed packet structure to have a next field to link free packets.
 * 
 * Revision 1.1  92/02/11  14:19:52  brewer
 * Initial revision
 * 
 \**************************************************************************/

#ifndef _PACKET_H_
#define _PACKET_H_

#include "net.h"  /* for MAX_PACKET_WORDS, SEND_RECEIVE */

#define MAX_PKT_TYPES   30

/* packet types */
#define CTOM_PKT         1
#define MTOC_PKT         2
#define NOCACHE_PKT      3

#define PKT_IPI          5
#define PKT_MEM          6

typedef struct packetStruct {
    Word data[MAX_PACKET_WORDS];
    struct packetStruct *next;
    int  length;
    char class;
} Packet;


typedef struct ipiStruct {
    Word itype; /* data[0] */
    Word iprio; /* data[1] */
    Word argc;  /* data[2] */
    Word argv;  /* data[3] */
} IpiPacket;


typedef struct {
    Word type;
    Word rest;
} MemPacket;


typedef struct {
    Word reqtype;
    Word processor;
    Word address;
    Word line;
    Word data;
} CCPacket;


typedef struct {
    Word reqtype;
    Word valaddr;
    Word address;
    Word mode;
    Word value;
} NOCPacket;


void dispatch_packet_(ulong sendtid, Time itime, int sender,
		     int target, Packet *packet);

void init_packet_(void);

#ifdef __STDC__
Packet *build_new_packet_(int class, int length, int argc, ...);
#else
Packet *build_new_packet_();
#endif

void DisplayPacket(FILE *out, Packet *packet);
void DisplayMessageQueue(FILE *out, int proc);

#endif /* #ifndef _PACKET_H_ */
