 
 /**************************************************************************\
 * 
 *                 Proteus Parallel-Architecture Simulator
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science    
 *                  Massachusetts Institute of Technology 
 * 
 * Module: processor.h -- Header file for processor management module
 * 
 * Description: Constants, Structures and Variables for processors
 * 
 * Last Modified: $Date: 94/01/24 00:39:17 $ (eab)                            
 * 
 * Data Structures:                                       
 *     ProcBlk: Structure with control information for a processor
 * 
 * Constants:                                             
 *     PROC_UTIL_WINDOW                                   
 *         Window used to measure processor utilization   
 *     PROCESSOR_MASK                                     
 * 
 * Referenced parameters:                                 
 *     SINGLE_RL, MULT_RL, NO_OF_PROCESSORS               
 * 
 * Macros:
 *     NotIdle(p)
 *     Idle(p)
 *     InvalidProc(p)
 *     MakeIdle(p)
 * 
 ****************************************************************************
 *   Copyright 1991                                                         *
 *   Eric A. Brewer  and  Chris N. Dellarocas                               *
 *   Massachusetts Institute of Technology                                  *
 *                                                                          *
 *   Permission to use, copy, modify, and distribute this program           *
 *   for any purpose and without fee is hereby granted, provided            *
 *   that this copyright and permission notice appear on all copies         *
 *   and supporting documentation, the name of M.I.T. not be used           *
 *   in advertising or publicity pertaining to distribution of the          *
 *   program without specific prior permission, and notice be given         *
 *   in supporting documentation that copying and distribution is           *
 *   by permission of M.I.T.  M.I.T. makes no representations about         *
 *   the suitability of this software for any purpose.  It is pro-          *
 *   vided "as is" without express or implied warranty.		            *
 ***************************************************************************
 * $Header: /usr/wildcat/dfk/research/parallel/proteus/proteus-V3.01/engine/RCS/processor.h,v 1.2 94/01/24 00:39:17 dfk Time64bit Locker: dfk $
 * $Log:	processor.h,v $
 * Revision 1.2  94/01/24  00:39:17  dfk
 * Added Sanjay's support for 64-bit timers.
 * Added thread_sleep_until.
 * Fixed a few bugs in thread sleep/wakeup code (my bugs).
 * Fixed printf formats in many places.
 * 
 * Revision 1.1  94/01/23  11:35:02  dfk
 * Initial revision
 * 
 * Revision 1.3  92/11/19  13:49:15  brewer
 * Moved UserPointer into processor.h, forcing callers to go through
 * the new set_local_pointers interface.
 * 
 * Revision 1.2  92/04/02  14:43:45  brewer
 * changed definition of ProcBlk.p_timer from Time to int
 * since it can be negative
 * 
 * Revision 1.1  92/02/11  14:19:53  brewer
 * Initial revision
 * 
 \**************************************************************************/

#define PROCESSOR_MASK      (NO_OF_PROCESSORS-1)

typedef struct {
          int  p_tid;
	  Time p_time;
	  Time p_timer;
	  FuncPtr p_timer_ihandler;
	  FuncPtr p_error_ihandler;
	  FuncPtr p_mismatch_ihandler;
	  FuncPtr p_switch_ihandler;
	  int  p_ihandler;
	  int  p_interrupted;
	  BOOL p_ihandleractive;
	  SimRequest *p_timerreq;
#ifdef SINGLE_RL
	  int p_nextidle;
#endif
#ifdef MULT_RL
          int  p_numthreads;
	  int  p_ready_head, p_ready_tail;
	  int  p_ready_threads;
#else
#ifndef SINGLE_RL
	  error: file OS.h is not included!!! /* generate compile-time error */
#endif
#endif
      } ProcBlk;

extern ProcBlk proc_table_[NO_OF_PROCESSORS];

extern int idle_processors;

#ifdef SINGLE_RL
extern int idle_head;
extern int ready_head, ready_tail;
extern int ready_threads;
#endif

extern ProcBlk *currpptr;      /* Pointer to current processor structure */

#ifdef SINGLE_RL
#define MakeIdle(p)            { \
				   proc_table_[(p)].p_tid = -1; \
				   idle_processors++; \
				   proc_table_[(p)].p_nextidle = idle_head; \
				   idle_head = p; \
			        }
#endif
#ifdef MULT_RL
#define MakeIdle(p)            { \
				   proc_table_[(p)].p_tid = -1; \
				   idle_processors++; \
			        }
#endif
				 
#define NotIdle(p)             (proc_table_[(p)].p_tid>=0)

#define Idle(p)                (proc_table_[(p)].p_tid<0)

#define InvalidProc(p)         (p<0 || p>=NO_OF_PROCESSORS)

void set_local_pointers(int proc);
