 /**************************************************************************\
 *
 *                 Proteus Parallel-Architecture Simulator
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science
 *                  Massachusetts Institute of Technology
 *
 * Module: profile.h
 *
 * Description: Loads and Outputs profile data, symbol table routines
 *
 * Last Modified:  12-Oct-92 (adj)
 *
 * Global Functions: none
 *
 * Global Variables: none
 *
 ****************************************************************************
 *   Copyright 1992
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ****************************************************************************
 * $Header: /psg/proteus/RCS/profile.h,v 1.3 92/11/13 17:03:24 brewer Exp $
 * $Log:	profile.h,v $
 * Revision 1.3  92/11/13  17:03:24  brewer
 * Removed compiler warnings.
 * 
 * Revision 1.2  92/11/03  13:30:45  brewer
 * Added FrameInfo typedef
 * Added LegalPointer macro
 * 
 * Revision 1.1  92/09/23  13:31:40  brewer
 * Initial revision
 * 
 * 
 \**************************************************************************/

typedef struct frame_info	/* Frame information */
{
  ulong return_pc_addr;		/* Address of return program counter */
  ulong fp, new_fp;		/* Values of current and parent frame ptrs */
  ulong sp, new_sp;		/* Values of current and parent stack ptrs */
  int pc_reg;			/* Number of register containg program ctr */
  ulong reg_mask;		/* Reg save mask (1 = reg saved in frame) */
  int frame_offset;		/* Size of frame */
  int frame_reg;		/* Number of register containing frame ptr */
  int has_frame_reg;	      	/* TRUE, if frame has a frame ptr register */
  int cur_sym;			/* Symbol table index of proc. for frame */
  int tid;			/* Thread owning this frame */
  /* For each register, address of where it was saved on entry to the frame,
     or zero if it was not saved on entry to this frame.  */
  ulong regs[32];
  struct frame_info *parent, *child;	/* Links to parent and child frames */
} FrameInfo;

typedef struct retval_ {
  ulong valueAddr;		/* Location of value */
  short type;			/* Type of value */
  ulong ripAddr;		/* Enclosing procedure's RIP location */
  ulong proc_start;		/* Procedure's starting address */
  char *name;			/* Name of enclosing procedure */
  FrameInfo *info;		/* Frame information */
  short pointer;  		/* TRUE, if procedure returns pointer */
} RetValue;

typedef struct frame_vars_ {
  ulong count;		/* Number of frame variables */
  ulong *vars;		/* Frame variables */
  short *types;		/* Type of variable */
} FrameVariables;

#define	FRAME_REG	1	/* Value in frame register */
#define FRAME_ABS	2	/* Value in frame */
#define FRAME_BSS	3	/* Value in bss */

extern void Fixup();

#define isSavedReg(REG)		\
  (((REG >= 16) && (REG <= 23)) || ((REG >= 29) && (REG <= 31)))

extern long _fdata; /* &_fdata = start of data area; see "man ld" */
extern char *sbrk();
#define LegalPointer(ADR)  \
  ((((long *) (ADR)) >= &_fdata) && (((long *) (ADR)) < (long *)sbrk(0)))

