 /**************************************************************************\
 *
 *                 Proteus Parallel-Architecture Simulator
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science
 *                  Massachusetts Institute of Technology
 *
 * Module: q.h
 *
 * Description: Thread queue definitions
 *
 * Last Modified:  12-Oct-92 (adj)
 *
 * Data Structures:
 *     Qnode
 *
 * Constants:
 *     QSIZ
 *     
 * Macros:
 *     isempty(l)
 *     nonempty(l)
 *     firstkey(l)
 *     lastkey(tl)
 *     firstid(l)
 *     
 * Referenced parameters:
 *     MAX_THREADS, MAX_SEMAPHORES, NO_OF_PROCESSORS, MULT_RL
 *
 ***************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ***************************************************************************
 * $Header: /usr/wildcat/dfk/research/parallel/proteus/proteus-V3.01/engine/RCS/q.h,v 1.2 94/01/24 00:39:23 dfk Time64bit Locker: dfk $
 * $Log:	q.h,v $
 * Revision 1.2  94/01/24  00:39:23  dfk
 * Added Sanjay's support for 64-bit timers.
 * Added thread_sleep_until.
 * Fixed a few bugs in thread sleep/wakeup code (my bugs).
 * Fixed printf formats in many places.
 * 
 * Revision 1.1  94/01/23  17:28:41  dfk
 * Initial revision
 * 
 * Revision 1.2  92/10/28  11:19:12  brewer
 * changed qkey from short to int
 * 
 * Revision 1.1  92/02/11  14:19:54  brewer
 * Initial revision
 * 
 \**************************************************************************/

#include "shmem.h"  /* for MAX_SEMAPHORES */

#ifdef SINGLE_RL
#define QSIZ    (MAX_THREADS + MAX_SEMAPHORES*2 + NO_OF_PROCESSORS*2 + 2)
#else
#ifdef MULT_RL
#define QSIZ    (MAX_THREADS + MAX_SEMAPHORES*2 + NO_OF_PROCESSORS*4)
#else
	  error: file OS.param is not included!!!
#endif
#endif

typedef struct {
    Time qkey;
    short qnext;
    short qprev;
} Qnode;

extern GLOBAL Qnode q[QSIZ];

#define isempty(l)       (q[(l)].qnext >= MAX_THREADS)
#define nonempty(l)      (q[(l)].qnext <  MAX_THREADS)
#define firstkey(l)      (q[q[(l)].qnext].qkey)
#define lastkey(tl)      (q[q[(tl)].qprev].qkey)
#define firstid(l)       (q[(l)].qnext)

