/*
 * $Header: /psg/proteus/RCS/rt_random.S,v 1.5 92/10/20 11:27:21 brewer Exp $
 *
 * $Log:	rt_random.S,v $
 * Revision 1.5  92/10/20  11:27:21  brewer
 * adj added vfast_random
 * 
 * Revision 1.4  92/09/23  12:28:52  brewer
 * (changed name from rt_random.s to rt_random.S)
 * 
 * Revision 1.3  92/04/02  15:44:49  brewer
 * *** empty log message ***
 * 
 * Revision 1.2  92/02/12  17:41:43  brewer
 * changed comment char to " * "
 * 
 * Revision 1.1  92/02/11  16:07:22  brewer
 * Initial revision
 * 
 * 
 *
 * Project:	PSG Runtime System Prototype
 * Module:	Fast Random Number Generator (for Scheduler)
 * Author:	Carl Waldspurger
 * History:
 *
 *      12-Oct-92 (adj) Added vfast_random
 *	01-Apr-91	Documented.
 *	pre Jan-91	Completed.
 *
 * Overview:
 *
 *   This module is a MIPS assembly-language implementation of the ACM
 *   "Minimal Standard Random Number Generator".  The implementation
 *   is based on:
 *	
 *	Park, S.K. and Miller, K.W.
 *      "Random Number Generators: Good Ones Are Hard To Find",
 *      CACM vol. 31, no. 10, October 1988.
 *
 *	Carta, D.G.
 *      "Two Fast Implementations of the 'Minimal Standard' Random Number Gen",
 *      CACM vol. 33, no. 1, January 1990.
 *
 */



/*
 * Static storage for random number generator state.
 * The inital value "1" is significant, since it permits optimizations.
 * Another good value is "40"; see the Carta article cited above.
 *
 * Note: This state could alternatively be passed as an argument
 *       to fast_random, in order to allow multiple random number
 *       generator "objects".
 *
 */
	.sdata
	.align 2
state:
	.word 	1 : 1

/*
 * Called from C as:
 *
 *	unsigned long fast_random();
 *
 * Note: For details of the underlying implementation, see the articles
 *       cited in the overview.  Basically, the following code implements
 *       the multiplicative linear congruential form: 
 *	
 *			S' = 16807 * S mod (2^31 - 1)
 *		
 */
	.text
	.globl	fast_random
	.align	2
	.ent 	fast_random
	.set	noat

fast_random:
	
	lw	$2, state		/* load old S into $2 */
	li	$8, 33614		/* $8 = 2 x constant A */
	multu	$2, $8			/* LO, HI = A x S */
	mflo	$9			/* $9  = Q = bits00..31 of A x S */
	srl	$9, $9, 1		
	mfhi	$10			/* $10 = P = bits32..63 of A x S */
	addu	$2, $9, $10		/* $2  = new S = P + Q */
	bltz    $2, overflow
	sw	$2, state		/* store $2 into new S */
	j	$31			/* return (result in $2) */

overflow:
	sll	$2, $2, 1		/* zero high order bit  of $2 */
	srl	$2, $2, 1
	addiu	$2, 1			/* add 1 */
	sw	$2, state		/* store $2 into new S */
	j	$31			/* return (result in $2) */

	.end	fast_random

/*
 * Called from C as:
 *
 *    unsigned long vfast_random(unsigned long state);
 *
 * Note: For details of the underlying implementation, see the articles
 *       cited in the overview.  Basically, the following code implements
 *       the multiplicative linear congruential form: 
 *    
 *                    S' = 16807 * S mod (2^31 - 1)
 *            
 */
      .text
      .globl  vfast_random
      .align  2
      .ent    vfast_random
      .set    noat

vfast_random:
      
      move    $2, $4                  /* load old S into $2 */
      li      $8, 33614               /* $8 = 2 x constant A */
      multu   $2, $8                  /* LO, HI = A x S */
      mflo    $9                      /* $9  = Q = bits00..31 of A x S */
      srl     $9, $9, 1               
      mfhi    $10                     /* $10 = P = bits32..63 of A x S */
      addu    $2, $9, $10             /* $2  = new S = P + Q */
      bltz    $2, voverflow
      j       $31                     /* return (result in $2) */

voverflow:
      sll     $2, $2, 1               /* zero high order bit  of $2 */
      srl     $2, $2, 1
      addiu   $2, 1                   /* add 1 */
      j       $31                     /* return (result in $2) */

      .end    vfast_random
