/* 
   Macros for manipulation thread ready queue timers
   Used in performance specification monitoring
   (Not a supported Proteus feature---under development)
   
   Sharon E. Perl  21 Feb 1992
*/

#include "monitorswitch.h"

#ifdef MONITORING_ON
#define RQTIMER_STOP(thread, time) \
        {CYCLE_COUNTING_OFF; \
        thread->t_rqtime += time - thread->t_rqstart; \
	thread->t_rqcount += 1; \
	if ((time - thread->t_rqstart) == 0) thread->t_rqzeros += 1; \
	CYCLE_COUNTING_ON;}

#define RQTIMER_START(thread, time) \
       {CYCLE_COUNTING_OFF; \
       thread->t_rqstart = time; \
       CYCLE_COUNTING_ON;}

#else

#define RQTIMER_STOP(thread, time)
#define RQTIMER_START(thread, time)

#endif
