
 /****************************************************************************
 *
 *                     Parallel Architecture Simulator     
 *                Eric A. Brewer  and  Chris N. Dellarocas 
 *                     Laboratory for Computer Science     
 *                  Massachusetts Institute of Technology  
 *
 * Module: shmem.c
 *
 * Description: initializes global data, includes appropriate code
 *
 * Last Modified: $Date: 92/11/03 14:36:03 $ (eab)
 *                  
 * Global Functions: none
 *                  
 * Global Variables:
 *     char *memory[MEMSIZE]   Storage for shared memory
 *     char *memtag[MEMSIZE]   Storage for shared-memory tags
 *     char *top_of_memory     Pointer to end of shared memory
 *
 *     char *mr_request_[]     Memory Request names
 *     char *cc_response_[]    Cache controller response names
 *                 
 ****************************************************************************
 * $Header: /psg/proteus/RCS/shmem.c,v 1.2 92/11/03 14:36:03 brewer Exp $
 * $Log:	shmem.c,v $
 * Revision 1.2  92/11/03  14:36:03  brewer
 * Added states names (mr_request_[] and cc_response_[]) for debugging
 * Added top_of_memory definition
 * filled in header comment fields
 * 
 * Revision 1.1  92/02/11  13:56:21  brewer
 * Initial revision
 * 
 ****************************************************************************/

#include "sim.h"
#include "conf.h"
#include "rt_thread_def.h"
#include "cache.h"
#include "shmem.h"

GLOBAL char memory[MEMSIZE];
GLOBAL char memtag[MEMSIZE];
GLOBAL char *top_of_memory = memory + MEMSIZE;

GLOBAL char *mr_request_[] = {"MR_READ", "MR_WRITE", "MR_READSOFT",
		              "MR_WRITESOFT", "MR_FLUSHSOFT", "MR_READFL",
		              "MR_WRITEFL", "MR_READTAG", "MR_WRITETAG"};
GLOBAL char *cc_response_[] = {"MEM_READY", "MEM_WAIT", "MEM_SWITCH",
			       "MEM_MISMATCH", "MEM_ERROR", "MEM_RETRY"};


#ifndef NOCACHE
#include "shmem.cache.c"
#else
#include "shmem.nocache.c"
#endif
