 
 /**************************************************************************\
 *
 *                 Proteus Parallel-Architecture Simulator
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science
 *                  Massachusetts Institute of Technology
 *
 * Module: simcalls.h -- Simulator Calls Symbolic Constants
 *
 * Description: Definitions of symbolic constants for all simulator calls.
 *
 * Last Modified: 5-28-90 (cnd) 6-5-91 (eab)
 *
 * Data Structures: None.
 *
 * Constants:
 *     SC_<simulator call name>
 *     MAX_SIMCALLS, MAX_DEFINED_IPI
 *     IPI_<ipi types>
 *
 * Referenced parameters:
 *     NOCACHE, MAX_INTR_TYPES
 *
 * Macros: SimCall macros
 *
 ***************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ***************************************************************************
 * $Header: /psg/proteus/RCS/simcalls.h,v 1.3 92/07/06 11:25:46 brewer Exp $
 * $Log:	simcalls.h,v $
 * Revision 1.3  92/07/06  11:25:46  brewer
 * Added MIN_USER_SC
 * Added declaration for print_request_
 * 
 * Revision 1.2  92/03/31  13:50:10  brewer
 * changed return types of shared memory handlers from int to void
 * 
 * Revision 1.1  92/02/11  14:20:00  brewer
 * Initial revision
 * 
 \**************************************************************************/

#ifndef SIMCALLS /* include at most once */
#define SIMCALLS

#include "sim.param"
#include "simreq.h"

#define MAX_SIMCALLS              64
#define MIN_USER_SC               32

#define SC_RESUME                 0
#define SC_TIMER                  1

#define SC_IPI_BUS                4
#define SC_NOP                    5

#define SC_SEND_PACKET            6
#define SC_RECV_PACKET            7
#define SC_ROUTE_PACKET           16

#define SC_SHARED_READ            17
#define SC_SHARED_WRITE           18

#define SC_SHARED_READ_FL         19
#define SC_SHARED_WRITE_FL        20

#define SC_FLUSH                  21

#define SC_SHARED_READTAG         22
#define SC_SHARED_WRITETAG        23

#define SC_SNAPSHOT               25

#define SC_SCHEDULE_INTR          26 /* alewife */

#define IPI_KILL_THREAD           0
#define IPI_SUSPEND_THREAD        1
#define IPI_RESUME_THREAD         2
#define IPI_SPAWN_THREAD          3
#define IPI_SET_PRIORITY          4
#define IPI_SET_PREEMPT           5
#define IPI_INTERRUPT_CTRL        6
#define IPI_J_SEND                7
#define IPI_VLOCK                 9

#define MAX_DEFINED_IPI           9

#define INTR_SEND_COMPLETE        50

#define IPI_BUS_RQ(to,from,fromtid,prio,type,argc,a1,a2,a3) \
  SimCall(SC_IPI_BUS,9,0,0,to,from,fromtid,prio,type,argc,a1,a2,a3)

#define SEND_PACKET_RQ(from,to,packet,ToResume) \
  SimCall(SC_SEND_PACKET,4,0,0,from,to,packet,ToResume)

#define SHARED_READ_RQ(proc,addr,mode,vaddr)  \
  SimCall(SC_SHARED_READ,4,0,0,proc,addr,mode,vaddr)
#define SHARED_WRITE_RQ(proc,addr,mode,vaddr,val) \
  SimCall(SC_SHARED_WRITE,5,0,0,proc,addr,mode,vaddr,val)

#define SHARED_READTAG_RQ(proc,addr,mode,vaddr)  \
  SimCall(SC_SHARED_READTAG,4,0,0,proc,addr,mode,vaddr)
#define SHARED_WRITETAG_RQ(proc,addr,mode,vaddr,val) \
  SimCall(SC_SHARED_WRITETAG,5,0,0,proc,addr,mode,vaddr,val)

#define SHARED_READ_FL_RQ(proc,addr,mode,vaddr)  \
  SimCall(SC_SHARED_READ_FL,4,0,0,proc,addr,mode,vaddr)
#define SHARED_WRITE_FL_RQ(proc,addr,mode,vaddr,val) \
  SimCall(SC_SHARED_WRITE_FL,5,0,0,proc,addr,mode,vaddr,val)

#ifndef NOCACHE
#define FLUSH_RQ(proc,addr)  \
  SimCall(SC_FLUSH,2,0,0,proc,addr)
#endif

void init_simcalls_();

void resume_handler_();
void ipi_bus_handler_();
void timer_interrupt_handler_();
void send_packet_handler_();
void receive_packet_handler_();
void route_packet_handler_();
void shared_read_handler_();
void shared_write_handler_();
void shared_readtag_handler_();
void shared_writetag_handler_();
void shared_read_fl_handler_();
void shared_write_fl_handler_();
void flush_handler_();
void snapshot_handler_();
void schedule_intr_handler_();

void ipi_OS_kill_handler_();
void ipi_OS_suspend_handler_();
void ipi_OS_resume_handler_();
void ipi_OS_set_priority_handler_();
void ipi_OS_set_preempt_handler_();
void ipi_OS_intr_ctrl_handler_();
void ipi_OS_spawn_handler_();
void null_handler_();

extern FuncPtr request_handler_[MAX_SIMCALLS];
extern FuncPtr intr_handler_[MAX_INTR_TYPES];
extern const char *request_name_[MAX_SIMCALLS];
extern const char *intr_name_[MAX_INTR_TYPES];
extern void (*print_request_[MAX_SIMCALLS])(FILE *, SimRequest *);

#endif /* ifndef SIMCALLS */
/* do not add code below this endif */
