
 /**************************************************************************\
 *                                                                          *
 *                 Proteus Parallel-Architecture Simulator                  *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module:  Simulator Request Routines                                      *
 *                                                                          *
 * Description: Basic Simulator Request routines                            *
 *                                                                          *
 * Last Modified:  6-5-91  (eab)                                            *
 *                                                                          *
 * Global Functions:                                                        *
 *     Word SimCall(int reqtype, unsigned argc, Word dummy1, Word dummy2,   *
 *                  Word args)                                              *
 *     void make_timer_request_(processor, tid, timestamp)                  *
 *     SimRequest *build_new_request_(int reqtype, int tid, Time timestamp, * 
 *                                   unsigned argc, Word args)              *
 *                                                                          *
 * Global Variables: none                                                   *
 *                                                                          *
 ****************************************************************************
 *   Copyright 1991                                                         *
 *   Eric A. Brewer  and  Chris N. Dellarocas                               *
 *   Massachusetts Institute of Technology                                  *
 *                                                                          *
 *   Permission to use, copy, modify, and distribute this program           *
 *   for any purpose and without fee is hereby granted, provided            *
 *   that this copyright and permission notice appear on all copies         *
 *   and supporting documentation, the name of M.I.T. not be used           *
 *   in advertising or publicity pertaining to distribution of the          *
 *   program without specific prior permission, and notice be given         *
 *   in supporting documentation that copying and distribution is           *
 *   by permission of M.I.T.  M.I.T. makes no representations about         *
 *   the suitability of this software for any purpose.  It is pro-          *
 *   vided "as is" without express or implied warranty.		            *
 ****************************************************************************
 * $Header: /psg/proteus/RCS/simreq.c,v 1.1 92/02/11 13:56:29 brewer Exp $
 * $Log:	simreq.c,v $
 * Revision 1.1  92/02/11  13:56:29  brewer
 * Initial revision
 * 
 \**************************************************************************/

#include "sim.h"
#include "conf.h"
#include "rt_thread_def.h"
#include "simcalls.h"
#include "simreq.h"
#include "processor.h"
#include "thread.h"

/* dummy1 and dummy2 are used to ensure that args is actually stored
 * on the stack. The first 4 arguments to a procedure may be stored
 * in registers
 */

/* build and enqueue a simulator request, then switch threads */

Word SimCall(int reqtype, unsigned argc, Word dummy1, Word dummy2,
	     Word args, ...)
{
    SimRequest *rptr;
    Word       *a, *ra;
    
    rptr = new_request_();
    
    rptr->h.reqtype = reqtype;
    rptr->h.tid = currtid;
    rptr->h.timestamp = CURRENTTIME;
    rptr->h.argc = argc;
    
    ra = rptr->argv;
    a = &args;
    for(; argc > 0; argc--) {
	*ra++ = *a++;
    }
    
    enqueue_request_(rptr);
    
    TrapToSimulator();
    
    return(result_);
}


/* build and enqueue an SC_TIMER request */
void make_timer_request_(proc, tid, timestamp)
int proc;
ulong tid;
Time timestamp;
{
    SimRequest *rptr;
    
    rptr = new_request_();
    rptr->h.reqtype = SC_TIMER;
    rptr->h.tid = tid;
    rptr->h.timestamp = timestamp;
    rptr->h.argc = 1;
    rptr->argv[0] = proc;

    proc_table_[proc].p_timerreq = rptr;
    
    enqueue_request_(rptr);
}


/* build, but do not enqueue, a simulator request */

SimRequest *build_new_request_(int reqtype, int tid, Time timestamp, 
			      unsigned argc, Word args)
{
    SimRequest *rptr;
    Word *a, *ra;
    int  i;
    
    rptr = new_request_();
    rptr->h.reqtype = reqtype;
    rptr->h.tid = tid;
    rptr->h.timestamp = timestamp;
    rptr->h.argc = argc;
    
    a = &args;
    ra = rptr->argv;
    for(i=0; i<argc; i++)
      *ra++ = *a++;
    
    return(rptr);
}
