 
 /**************************************************************************\
 *                                                                          *
 *                 Proteus Parallel-Architecture Simulator                  *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module:  Simulator Request Data Structure                                *
 *                                                                          *
 * Description:  This file defines the primary data structure for simulator *
 *     request blocks.  It also declares the priority queue routines and    *
 *     globals.                                                             *
 *                                                                          *
 * Last Modified:  6-4-91  (eab)                                            *
 *                                                                          *
 * Types: SimRequest                                                        *
 *                                                                          *
 * Constants: R_FREE, R_ACTIVE                                              *
 *                                                                          *
 ****************************************************************************
 *   Copyright 1991                                                         *
 *   Eric A. Brewer  and  Chris N. Dellarocas                               *
 *   Massachusetts Institute of Technology                                  *
 *                                                                          *
 *   Permission to use, copy, modify, and distribute this program           *
 *   for any purpose and without fee is hereby granted, provided            *
 *   that this copyright and permission notice appear on all copies         *
 *   and supporting documentation, the name of M.I.T. not be used           *
 *   in advertising or publicity pertaining to distribution of the          *
 *   program without specific prior permission, and notice be given         *
 *   in supporting documentation that copying and distribution is           *
 *   by permission of M.I.T.  M.I.T. makes no representations about         *
 *   the suitability of this software for any purpose.  It is pro-          *
 *   vided "as is" without express or implied warranty.		            *
 ***************************************************************************
 * $Header: /usr/wildcat/dfk/research/parallel/proteus/proteus-V3.01/engine/RCS/simreq.h,v 1.2 94/01/24 00:39:38 dfk Time64bit Locker: dfk $
 * $Log:	simreq.h,v $
 * Revision 1.2  94/01/24  00:39:38  dfk
 * Added Sanjay's support for 64-bit timers.
 * Added thread_sleep_until.
 * Fixed a few bugs in thread sleep/wakeup code (my bugs).
 * Fixed printf formats in many places.
 * 
 * Revision 1.1  94/01/23  11:35:27  dfk
 * Initial revision
 * 
 * Revision 1.1  92/02/11  14:20:01  brewer
 * Initial revision
 * 
 \**************************************************************************/

#ifndef SIMREQ /* include at most once */
#define SIMREQ

/* Request blocks are either free or active */
#define R_FREE             0
#define R_ACTIVE           1

#define REQ_MAX_ARGS       32        /* max no of args in any sim.call */

/* Simulator Request Block */

struct simreq;
typedef struct {
    int        status;              /* slot status: R_FREE / R_ACTIVE        */
    int        tid;                 /* thread associated with this request   */
    int        reqtype;             /* request type                          */
    struct simreq     *nextreq;     /* next request or next free slot        */
    Time       timestamp;           /* timestamp of request                  */
                                    /* (used to order it in queue)           */
    int        argc;                /* argument count (0 if no arguments)    */
} SimHeader;

typedef struct simreq {
    SimHeader  h;
    Word       argv[REQ_MAX_ARGS];  /* argument vector                       */
} SimRequest;


extern GLOBAL int hash_index_;
extern GLOBAL Time hash_time_;

#endif
