
/**************************************************************************\
 *                                                                          *
 *                 Proteus Parallel-Architecture Simulator                  *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module: timer.c                                                          *
 *                                                                          *
 * Description: Per-processor timer module                                  *
 *                                                                          *
 * Last Modified:  $Date: 94/01/24 00:39:41 $  (eab)
 *                                                                          *
 * Global Functions:                                                        *
 *     long ReadTimer(int proc)                                             *
 *     void WriteTimer(int proc, Time time)                                 *
 *     void timer_interrupt_handler_(SimRequest *rptr)                      *
 *                                                                          *
 * Global Variables: none                                                   *
 *                                                                          *
 ****************************************************************************
 *   Copyright 1991                                                         *
 *   Eric A. Brewer  and  Chris N. Dellarocas                               *
 *   Massachusetts Institute of Technology                                  *
 *                                                                          *
 *   Permission to use, copy, modify, and distribute this program           *
 *   for any purpose and without fee is hereby granted, provided            *
 *   that this copyright and permission notice appear on all copies         *
 *   and supporting documentation, the name of M.I.T. not be used           *
 *   in advertising or publicity pertaining to distribution of the          *
 *   program without specific prior permission, and notice be given         *
 *   in supporting documentation that copying and distribution is           *
 *   by permission of M.I.T.  M.I.T. makes no representations about         *
 *   the suitability of this software for any purpose.  It is pro-          *
 *   vided "as is" without express or implied warranty.		            *
 ****************************************************************************
 * $Header: /usr/wildcat/dfk/research/parallel/proteus/proteus-V3.01/engine/RCS/timer.c,v 1.2 94/01/24 00:39:41 dfk Time64bit Locker: dfk $
 * $Log:	timer.c,v $
 * Revision 1.2  94/01/24  00:39:41  dfk
 * Added Sanjay's support for 64-bit timers.
 * Added thread_sleep_until.
 * Fixed a few bugs in thread sleep/wakeup code (my bugs).
 * Fixed printf formats in many places.
 * 
 * Revision 1.1  94/01/23  11:35:31  dfk
 * Initial revision
 * 
 * Revision 1.3  92/04/02  16:49:36  brewer
 * Changed ReadTimer to return nonnegative value
 * Changed WriteTimer to accept negative times
 * 
 * Revision 1.2  92/03/31  16:49:41  brewer
 * changes ReadTimer, WriteTimer to take and return long time values
 * 
 * Revision 1.1  92/02/11  13:56:33  brewer
 * Initial revision
 * 
 \**************************************************************************/

#include "sim.h"
#include "conf.h"
#include "rt_thread_def.h"
#include "simreq.h"
#include "processor.h"
#include "thread.h"
#include "simcalls.h"
#include "event.h"

/* Functions to Read and Set the timer on a processor */

Time ReadTimer(int p) 
{
    /* will always be >= 0 because Time is an unsigned number */
    return(proc_table_[p].p_timer);
}


void WriteTimer(int p, Time v) 
{
    proc_table_[p].p_timer = v;
}


/* Request handler for SC_TIMER request */

void timer_interrupt_handler_(rptr) 
SimRequest * rptr ;
{
    int p = rptr->argv[0];
    ProcBlk *pptr = &proc_table_[p];

    pptr->p_timerreq = NULL;

    if (Idle(p)) {
	WriteTimer(p, (Time) 0);
	pptr->p_tid = pptr->p_ihandler;
	pptr->p_interrupted = ERROR;
	T_OSBLOCK(pptr->p_ihandler)->t_state = T_CURRENT;
	
	idle_processors--;
	
	if (rptr->h.timestamp < pptr->p_time) {
	    /* this case can occur if the processor just became idle */
	    rptr->h.timestamp = pptr->p_time;
	}

	EVENT_BUSY(rptr->h.timestamp, p);
	
	MAKE_RESUME_REQUEST(pptr->p_ihandler, rptr->h.timestamp, NULL);
    }
}

