 /**************************************************************************\
 * fatal.c, part of simex
 *
 *  David Kotz, 1996
 *
 *  simex is a stripped-down version of stats, in which I tossed all 
 * of the GUI and graph-making stuff.  It's just enough to read events.sim
 * and print out the metrics. 
 *
 * DERIVED FROM
 *
 *
 *                 Proteus Parallel-Architecture Simulator
 *                Eric A. Brewer  and  Chris N. Dellarocas
 *                     Laboratory for Computer Science
 *                  Massachusetts Institute of Technology
 *
 * Module: fatal.c (stats)
 *
 * Description: Fatal error handler (for stats)
 *
 * Last Modified: $Date: 1996/07/04 03:30:05 $ ($Author: dfk $)
 * Revision $Revision: 1.4 $
 *
 * Global Functions:
 *     void fatal(cosnt char *format, arg1, ...)
 *
 * Global Variables: none
 *
 ***************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.		
 ***************************************************************************
 *
 * $Log: fatal.c,v $
 * Revision 1.4  1996/07/04 03:30:05  dfk
 * this is a nice working version.
 *
 * Revision 1.3  1996/07/02 02:58:17  dfk
 * completely new command-line interface
 * detailed control over what gets printed
 * ability to use abbreviated names for metrics
 *
 * Revision 1.2  1996/07/01 22:51:44  dfk
 * first really working version
 *
 * Revision 1.1  1996/06/30 21:33:10  dfk
 * Initial revision
 *
 * Revision 1.1  92/09/14  12:45:24  brewer
 * Initial revision
 * 
 * 
 \**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#define GLOBAL

#ifdef __STDC__
#include <stdarg.h>

GLOBAL void fatal(const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);

    fprintf(stderr, "Fatal Error: ");
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n\n");
    
    exit(1);
    va_end(ap);
}

#else  /* DEC Ultrix cc compiler */

#include <varargs.h>

GLOBAL void fatal(va_alist)
    va_dcl
{
    va_list ap;
    va_start(ap);

    fprintf(stderr, "Fatal Error: ");
    vfprintf(stderr, va_arg(ap, char *), ap);
    fprintf(stderr, "\n\n");
    
    exit(1);
    va_end(ap);
}

#endif /* __STDC__ */
