/* @TITLE "barrier.h: interface for barrier.ca" */
/*
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 *
 * $Id: barrier.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $
 */

/* Implemented by Ting Cai, January 1996
 * based on algorithm by David Kotz, 
 * and earlier implementation by Ahsan Khabir
 */

#ifndef BARRIER_H
#define BARRIER_H

/* barrier_init is called once from driver.c to initialize those 
 * barrier related data structure. 
 */

extern void barrier_init();


extern void barrier(int lowest, int numprocs);

/* SPLIT BARRIER:
 * split_barrier returns TRUE if you are the lowest in the group. 
 * After taking care of any business, you must then call barrier_release.
 * The point of split barrier is that you separate (split) the arrival 
 * at the barrier from the departure (release) from the barrier, so that 
 * one proc can do something during that moment of synchrony when everyone 
 * has arrived but no one has continued.
 */

extern boolean split_barrier(int lowest, int numprocs);
extern void barrier_release(int lowest, int numprocs); 

#endif /* BARRIER_H */
