/* @TITLE "disklayout.h: Definitions for disk-layout module"*/
/* 
 * Interface for the disk-layout module.
 *
 * functions:
 *  DiskLayout
 *  DiskLayoutDone
 *  DiskLayoutSet
 *  DiskLayoutGet
 *  DiskLayoutGetRange
 *  DiskLayoutSorted
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: disklayout.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */
/* Based on disk.h,v 1.33 93/12/24 12:40:44 dfk GENERALWORKS */

#ifndef DISKLAYOUT_H
#define DISKLAYOUT_H

/* FUNCTIONS */
/* Layout a file on disk. That is, choose a physical sector for 
 * each logical diskblock number in [firstblock..lastblock], assuming
 * the given block size (bytes), and according to your layout policy.  
 * The layout is remembered for future use below.
 */
extern void DiskLayout(int disk, ulong firstblock, ulong lastblock, 
		       ulong blockSize);

/* return the range of disk blocks for that disk */
extern void DiskLayoutGetRange(int disk, ulong *firstblock, ulong *lastblock);

/* clean up any data structures */
extern void DiskLayoutDone(void);

/* DiskLayoutSorted: create global blockList sorted by sector" */
/* return the total number of blocks involved. */
/* Will assign global blockList pointer if called after both blocklist and */
/* 	the pointer passed in have been initialized. */
int DiskLayoutSorted(int disk, ulong **blockList, 
		     ulong firstblock, ulong lastblock);

/* Set the sector where this disk/diskblock can be found.
 * We trust the caller to know that this is ok.
 */
extern void DiskLayoutSet(int disk, ulong diskblock, ulong sector);

/* Return the sector where this disk/diskblock can be found.
 * If 'set' is true, then don't use the predetermined place for this
 * block; instead use the "closest" layout position to the one you
 * used last. nsectors will tell how many sectors are in this block.
 */
extern void DiskLayoutGet(int disk, ulong diskblock, ulong *sector, 
			  ulong *nsectors, boolean set);

#endif /* DISKLAYOUT_H */
