/* @TITLE "diskq.h: dual-queue data structure"*/
/* 
 * diskq: an abstract data type to support the disk-request 
 * queue used in Diskdriver.  You can enqueue requests and dequeue requests.
 * Dequeue blocks you if the queue is empty.  During enqueue
 * it will position the new item according to the disk scheduling 
 * strategy.
 *
 * There should only be one thread dequeuing from any given queue!
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: diskq.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef DISKQ_H
#define DISKQ_H

#include "diskdriver.h"	      /* for typedef */
#include "diskreq.h"	      /* for DiskRequest */

typedef struct diskq_s DISKQ; /* Diskq handle */

extern DISKQ *MakeDiskq(int disk); /* make a new queue */
extern void PrintDiskq(DISKQ *q); /* print */
extern void EnqDiskq(DISKQ *q, DiskRequest *req); /* enqueue */
extern void DeqDiskq(DISKQ *q, DiskRequest **req); /* dequeue (might block) */
extern boolean EmptyDiskq(DISKQ *q); /* TRUE if diskq is empty */
extern int InDiskq(DISKQ *q); /* number in queue now */
extern void FreeDiskq(DISKQ *q); /* destroy a diskq */

#endif DISKQ_H
