/* @TITLE "dualq.h: dual-queue data structure"*/
/* 
 * dualq: a dual-queue is a producer-consumer queue that can either
 * be holding a surplus of items (which are produced by producers),
 * waiting to be consumed by consumers, or a deficit of items, which are
 * represented by waiting consumers on the queue.  A consumer waits
 * by blocking its thread; a producer wakes that thread up. Thus it
 * provides FIFO access for multiple producers and multiple consumers.
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: dualq.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef DUALQ_H
#define DUALQ_H

typedef struct dualq_s DUALQ; /* Dualq handle */
typedef void *DQitem;	      /* a queue item is any pointer */

extern DUALQ *MakeDualq(int size, char *debugname); /* make a new queue */
extern void EnqDualq(DUALQ *q, DQitem item); /* enqueue */
extern void DeqDualq(DUALQ *q, DQitem *item); /* dequeue (might block) */
extern int InDualq(DUALQ *q); /* > 0 is surplus, < 0 is deficit */
extern boolean EmptyDualq(DUALQ *q); /* TRUE if dualq is empty */
extern void FreeDualq(DUALQ *q); /* destroy a dualq */

#endif DUALQ_H
