/* @TITLE "file.h: Definitions about the file"*/
/* 
 * Some basic parameters about the file, derived from the even more basic
 * stuff in file.param.  I don't let config do these derivations because
 * I don't trust its math.
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: file.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef FILE_H
#define FILE_H

#include "disk.h"
#include "file.param"

#define NUM_RECORDS ((ulong)(FILE_BLOCKS_MAX * BLOCK_SIZE / RECORD_SIZE))
#define FILE_SIZE   ((ulong)(NUM_RECORDS * RECORD_SIZE))
#define FILE_BLOCKS ((ulong)((FILE_SIZE + BLOCK_SIZE - 1) / BLOCK_SIZE))

#endif FILE_H
