/* 
 * linkfiles -- a program to make links to a list of files, from the 
 * given directory, in the current directory.
 *
 * usage: 
 *   linkfiles dir file...
 * For each file, it makes a symbolic link from dir/file named ./file.
 *
 * David Kotz 1992
 *
 */

#include <stdio.h>
#include <errno.h>

#define MAXLEN 300

main(int argc, char **argv)
{
    char *filename;
    char *dirname;
    char fullname[MAXLEN];
    int result;

    if (argc <= 2) {
	   fprintf(stderr, "usage: %s dir file...\n", argv[0]);
	   exit(1);
    }

    dirname = argv[1];

    argc -= 2;
    argv += 2;
    
    while (argc-- > 0) {
	   filename = *argv++;
	   sprintf(fullname, "%s/%s", dirname, filename);
	   result = symlink(fullname, filename);
	   if (result != 0)
		if (errno != EEXIST)
		  perror(filename);
    }

    exit(0);
}
