/* @TITLE "permute.h: permutation support"*/
/* 
 * Support for permuting data, in two-phase I/O.   Used by cp.ca 
 * and cpfs-direct-stubs.ca.
 *
 * functions:
 *   Permute_setup
 *   Permute_put
 *   Permute_put_long
 *   Permute_get
 *   Permute_get_long
 *   Permute_finish
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: permute.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef PERMUTE_H
#define PERMUTE_H

/* Pre-initialize some necessary data structures. */
extern void Permute_init(int CPnum);

/* Make the arrangements to begin a permutation.  Basically, that
 * means setting up for memput/memget.
 */
extern void Permute_setup(boolean write, UserData tempbuf);

/* Put data from local userbuf to remote tempbuf, using Memput. */
extern void Permute_put(UserData userbuf, int CPnum, 
			ulong CPoffset, ulong nbytes);

/* Like Permute_put, but for nbytes > BLOCK_SIZE. */
extern void Permute_put_long(UserData userbuf, int CPnum, 
			     ulong CPoffset, ulong nbytes);

/* Get data from  remote tempbuf to local userbuf, using Memget. */
extern void Permute_get(UserData userbuf, int CPnum, 
			ulong CPoffset, ulong nbytes);

/* Like Permute_get, but for nbytes > BLOCK_SIZE. */
extern void Permute_get_long(UserData userbuf, int CPnum, 
			     ulong CPoffset, ulong nbytes);

/* Finish doing a permutation.  Basically, that 
 * means cleaning up from memput/memget.
 */
extern void Permute_finish(boolean write, UserData tempbuf);

#endif PERMUTE_H
