/* @TITLE "ready.h: interface for ready.ca" */
/*
 * ready - interface for a of a simple "I am ready" reduction
 * ANSI C
 *
 * This is the simplest form of reduction, where we just want everyone
 * to say they are "ready"; essentially, this is half of a barrier. 
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 *
 * $Id: ready.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $
 */

#ifndef READY_H
#define READY_H

/* Called once to initialize the counter data structure
 * It automatically reinitializes after each use,
 * but you can call it again (while there is no active ready reduction)
 * to reset the value of nprocs.
 * Procs [0..nprocs) participate.
 */
extern void ready_init(int nprocs);

/* 
 * For the local processor to assert its readiness.
 * For calling when you are NOT inside an interrupt handler.
 */
extern void ready(void);

/* 
 * For the local processor to assert its readiness.
 * This is for calling when you're in an interrupt handler.
 */
extern void readyI(void);

/* 
 * Processor 0 can wait until everyone is ready. 
 * It should assert its own readiness first, by calling ready().
 */
extern void wait_all_ready(void);

#endif /* READY_H */
