# a nawk script
#
# caller must set xfield= on the command line


# Part of
#              The STARFISH Parallel file-system simulator
#        (Simulation Tool for Advanced Research in File Systems)
# 
#                               David Kotz
#                           Dartmouth College
#                              Version 3.0
#                              January 1996
#                          dfk@cs.dartmouth.edu
#

#   1      2     3       4        5             6
# Pattern CPFS IOPFS DISK_SORT RECORD_SIZE DISK_LAYOUT 
#  7              8      9    10     11         12     13
# FILE_BLOCKS BLOCK_SIZE Nio Ncomp NO_OF_DISKS total tthruput

function initnames()
{
    i = 0;

    patname[i++] =     "nullcommtest";
    patname[i++] =     "datacommtest";
    patname[i++] =     "memgettest";
    patname[i++] =     "copytest";
    patname[i++] =     "disktest";

    # LU patterns
    patname[i++] =     "luinit";
    patname[i++] =     "lu";

    # plain patterns 
    patname[i++] =     "rrlw";
    patname[i++] =     "rrlps";
    patname[i++] =     "brlw";
    patname[i++] =     "rwlw";
    patname[i++] =     "bwlw";
    patname[i++] =     "wrlw";
    patname[i++] =     "wrlw1";
    patname[i++] =     "wwlw1";
    patname[i++] =     "wrseg";
    patname[i++] =     "wwseg";

    # Read, 1-D distributions 
    patname[i++] =     "wrn";
    patname[i++] =     "wrb";
    patname[i++] =     "wrc";

    # Read, 2-D DISTRIBUTION(NONE, ...) 
    patname[i++] =     "wrnn";
    patname[i++] =     "wrnb";
    patname[i++] =     "wrnc";

    # Read, 2-D DISTRIBUTION(BLOCK, ...) 
    patname[i++] =     "wrbn";
    patname[i++] =     "wrbb";
    patname[i++] =     "wrbc";

    # Read, 2-D DISTRIBUTION(CYCLIC, ...) 
    patname[i++] =     "wrcn";
    patname[i++] =     "wrcb";
    patname[i++] =     "wrcc";

    # Write, 1-D distributions 
    patname[i++] =     "wwn";
    patname[i++] =     "wwb";
    patname[i++] =     "wwc";

    # Write, 2-D DISTRIBUTION(NONE, ...) 
    patname[i++] =     "wwnn";
    patname[i++] =     "wwnb";
    patname[i++] =     "wwnc";

    # Write, 2-D DISTRIBUTION(BLOCK, ...) 
    patname[i++] =     "wwbn";
    patname[i++] =     "wwbb";
    patname[i++] =     "wwbc";

    # Write, 2-D DISTRIBUTION(CYCLIC, ...) 
    patname[i++] =     "wwcn";
    patname[i++] =     "wwcb";
    patname[i++] =     "wwcc";

    # new special patterns
    patname[i++] =     "subset";
    patname[i++] =     "hash";
    numpats = i;

# using short names to keep plot-file lines from being too long
    sortname[0] = "ns";		# nosort
    sortname[1] = "s";		# sort

    i = 0;
    cpfsname[i++] = "none";
    cpfsname[i++] = "single";
    cpfsname[i++] = "double";
    cpfsname[i++] = "thread";
    cpfsname[i++] = "direct";

# using short names to keep plot-file lines from being too long
    i = 0;
    iopfsname[i++] = "n";	# none
    iopfsname[i++] = "b";	# buffer
    iopfsname[i++] = "c";	# cache
    iopfsname[i++] = "d";	# direct
    iopfsname[i++] = "g";	# general

# using short names to keep plot-file lines from being too long
    layoutname[0] = "c";	# contig
    layoutname[1] = "rs";	# rsectors
    layoutname[2] = "rt";	# rtracks
}

function max(a,b) { return (a < b ? a : b); }

BEGIN {
  initnames();
  # max transfer rate, per disk, assuming we're crossing several tracks 
  # and thus have to pay head-switch delays.  Cylinder-switch delays are 
  # ignored here.
  maxPerDisk = (72 * 512 / 1024.) / (80 / 72. / 4002. * 60); # KB/s
  # Assuming 10 MB/s Fast SCSI 
  maxPerBus = 10 * 1024; # KB/s
  datafilebase = "/tmp/dotrend/data"
  plotfile = "/tmp/dotrend/plot"
  maxfile = "/tmp/dotrend/max"
  print "set ylabel \"KB/s\"" >> plotfile;
  print "set xlabel \"field " xfield "\"" >> plotfile;
  print "set data style linespoints" >> plotfile;
}

# for every input line
{
  y=$13;
  if (patname[$1] == "wrlw") y /= $10; # scale by Ncomp

  config = iopfsname[$3] "." sortname[$4] "." layoutname[$6];
  pat = patname[$1];
  datafile = datafilebase "." config "." pat;
  print $xfield, y > datafile;

  if ( !($xfield in maxcurve)) {
#                       max(Ndisk * maxPerDisk, Nio * maxPerBus);
    maxcurve[$xfield] = max($11 * maxPerDisk, $9 * maxPerBus);
    print $xfield, maxcurve[$xfield] > maxfile;
  }

  configs[config] = 1;
  pats[$1] = 1;
  curves[config "." pat] = 1;
}

END {
  printf "plot '%s' w lines 6,", maxfile >> plotfile;
#  printf "plot " >> plotfile;

  linestyle = 0;
  for (config in configs) {
      linestyle++;

      pointstyle = 0;
      for (i = 0; i < numpats; i++) {
	if (pats[i] == 1) {
	  pat = patname[i];
	  pointstyle++;
	  c = (config "." pat);
	  if ( curves[c] != 1 ) continue;
	  
	  datafile = datafilebase "." c;
	  printf ("\\\n '%s' title '%s' w linesp %d %d,", 
		  datafile, c, linestyle, pointstyle) >> plotfile;
	}
      }
  }
  printf "0 notitle\n" >> plotfile;
}
