# a nawk script
# variable "layout" must be set to rsectors or contig, on the command line

# Part of
#              The STARFISH Parallel file-system simulator
#        (Simulation Tool for Advanced Research in File Systems)
# 
#                               David Kotz
#                           Dartmouth College
#                              Version 3.0
#                              January 1996
#                          dfk@cs.dartmouth.edu
#

# If layout=contig, INPUT COLUMNS ARE:
# 1 pat
#
# 2 8.cache.nosort
# 3 8.general.nosort 
# 4 8.general/cache.nosort
# 5 significant yes/no
#
# 6 8192.cache.nosort
# 7 8192.general.nosort
# 8 8192.general/cache.nosort
# 9 significant yes/no
#
# where 2-4,6-8 are thruputs in MB/s

# If layout=rsectors, INPUT COLUMNS ARE:
# 1 pat
#
# 2 8.cache.nosort
# 3 8.general.nosort 
# 4 8.general/cache.nosort
# 5 significant yes/no
# 6 8.cache.nosort (again)
# 7 8.general.sort
# 8 8.general/cache.sort
# 9 significant yes/no
#
# 10 8192.cache.nosort
# 11 8192.general.nosort
# 12 8192.general/cache.nosort
# 13 significant yes/no
# 14 8192.cache.nosort (again)
# 15 8192.general.sort
# 16 8192.general/cache.sort
# 17 significant yes/no
#
# where 2-4,6-8,10-12,14-16 are thruputs in MB/s


BEGIN {
    dosort = (layout == "rsectors" ? 1 : 0);
    s["no"] = "\\em";		# so non-significant things are italicized
    s["yes"] = "";

    if (dosort) {
      print "\\begin{tabular}{l|r|rr|rr||r|rr|rr|}";
      printf " & \\multicolumn{10}{c|}{Random-blocks layout} \\\\\n ";

      printf " & \\multicolumn{5}{c||}{8-byte records} & ";
      printf "\\multicolumn{5}{c|}{8192-byte records} \\\\\n";

      printf "Pattern & ";
      printf "TC & DD & $r$ & DDs & $r$ & ";
      printf "TC & DD & $r$ & DDs & $r$  \\\\\n";
      print "\\hline";
    } else {
      print "\\begin{tabular}{l|rrr||rrr|}";
      printf " & \\multicolumn{6}{c|}{Contiguous layout} \\\\\n ";
      printf " & \\multicolumn{3}{c||}{8-byte records} & ";
      printf "\\multicolumn{3}{c|}{8192-byte records} \\\\\n";

      printf "Pattern & ";
      printf "TC & DD & $r$ & ";
      printf "TC & DD & $r$  \\\\\n";
      print "\\hline";
    }

}

# draw an hline before wrn and wwn
{
    if ($1 == "wwn" || $1 == "wrn") print "\\hline";
}

# one row for each input line, if dosort (ie, rsectors layout)
dosort {
    printf "\\%s/ & ", $1; # pat
# 8-byte records
    if ($2 != "x") {
	printf "%4.1f & %4.1f & {%s %5.2f} & ", $2, $3, s[$5], $4;
	printf "%4.1f & {%s %5.2f} & ", $7, s[$9], $8;
    } else {	# one of those cases where record size does not matter
	printf " -   & -   & -   & ";
	printf " -   & -   & ";
    }
# 8192-byte records
    if ($10 != "x") {
      printf "%4.1f & %4.1f & {%s %5.2f} & ", $10, $11, s[$13], $12;
      printf "%4.1f & {%s %5.2f} \\\\\n", $15, s[$17], $16;
    } else {			# something went wrong
      printf " -   & -   & -  & - &  \\\\\n";
    }
}

# one row for each input line, if not dosort (ie, contig layout)
!dosort {
    printf "\\%s/ & ", $1; # pat
# 8-byte records
    if ($2 != "x") {
	printf "%4.1f & %4.1f & {%s %5.2f} & ", $2, $3, s[$5], $4;
    } else {	# one of those cases where record size does not matter
	printf " -   & -   & -   & ";
    }
# 8192-byte records
    if ($6 != "x") {
      printf "%4.1f & %4.1f & {%s %5.2f} \\\\\n", $6, $7, s[$9], $8;
    } else {			# something went wrong
      printf " -   & -   & -   \\\\\n";
    }
}

END {
    print "\\hline"
    print "\\end{tabular}"
}
