# Part of
#              The STARFISH Parallel file-system simulator
#        (Simulation Tool for Advanced Research in File Systems)
# 
#                               David Kotz
#                           Dartmouth College
#                              Version 3.0
#                              January 1996
#                          dfk@cs.dartmouth.edu
#

BEGIN {
    i = 0;

    patname[i++] =     "nullcommtest";
    patname[i++] =     "datacommtest";
    patname[i++] =     "memgettest";
    patname[i++] =     "copytest";
    patname[i++] =     "disktest";

    # plain patterns 
    patname[i++] =     "rrlw";
    patname[i++] =     "rrlps";
    patname[i++] =     "brlw";
    patname[i++] =     "rwlw";
    patname[i++] =     "bwlw";
    patname[i++] =     "wrlw";
    patname[i++] =     "wrlw1";
    patname[i++] =     "wwlw1";
    patname[i++] =     "wrseg";
    patname[i++] =     "wwseg";

    # Read, 1-D distributions 
    patname[i++] =     "wrn";
    patname[i++] =     "wrb";
    patname[i++] =     "wrc";

    # Read, 2-D DISTRIBUTION(NONE, ...) 
    patname[i++] =     "wrnn";
    patname[i++] =     "wrnb";
    patname[i++] =     "wrnc";

    # Read, 2-D DISTRIBUTION(BLOCK, ...) 
    patname[i++] =     "wrbn";
    patname[i++] =     "wrbb";
    patname[i++] =     "wrbc";

    # Read, 2-D DISTRIBUTION(CYCLIC, ...) 
    patname[i++] =     "wrcn";
    patname[i++] =     "wrcb";
    patname[i++] =     "wrcc";

    # Write, 1-D distributions 
    patname[i++] =     "wwn";
    patname[i++] =     "wwb";
    patname[i++] =     "wwc";

    # Write, 2-D DISTRIBUTION(NONE, ...) 
    patname[i++] =     "wwnn";
    patname[i++] =     "wwnb";
    patname[i++] =     "wwnc";

    # Write, 2-D DISTRIBUTION(BLOCK, ...) 
    patname[i++] =     "wwbn";
    patname[i++] =     "wwbb";
    patname[i++] =     "wwbc";

    # Write, 2-D DISTRIBUTION(CYCLIC, ...) 
    patname[i++] =     "wwcn";
    patname[i++] =     "wwcb";
    patname[i++] =     "wwcc";

    sort[0] = "";
    sort[1] = "sort";

    i = 0;
    cpfsname[i++] = "none";
    cpfsname[i++] = "single";
    cpfsname[i++] = "double";
    cpfsname[i++] = "thread";
    cpfsname[i++] = "direct";

    i = 0;
    iopfsname[i++] = "none";
    iopfsname[i++] = "buffer";
    iopfsname[i++] = "cache";
    iopfsname[i++] = "direct";
    iopfsname[i++] = "general";

    layout[0] = "contig";
    layout[1] = "rsectors";
    layout[2] = "rtracks";
}

# for every input line
{
    if ($1 != lastpat) {	      # print header at start of a new pattern
printf "\n%-7s %-6s %-7s %-4s %6s %-8s %9s %3s %5s %5s %5s %9s %9s %6s\n", \
	  "Pattern", "CPFS", "IOPFS", "SORT", "RSIZE", "LAYOUT", \
	    "File-MB", "Nio", "Ncomp", "Ndisk", "Trial", "Time(s)", "KB/s", "MB/s"
    }

    printf"%-7s %-6s %-7s %-4s %6d %-8s %9.f %3d %5d %5d %5d %9.3f %9.1f %6.2f\n",\
      patname[$1], cpfsname[$2], iopfsname[$3], sort[$4], $5, layout[$6],\
	$7 * $8 / 1024. / 1024., $9, $10, $11, $14, $12, $13, $13/1024.

    lastpat = $1;
}

