/* @TITLE "stats.h: DMCACHE statistics"*/
/* 
 * This defines the metrics, stats, and events used by DMCACHE.
 * types:
 *   struct stats
 *   METRIC
 *   STAT
 * variables:
 *   stats
 * function:
 *   InitStats
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: stats.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef STATS_H
#define STATS_H

/* load the events, and macros for metrics, stats, and events  */
#include "user-events.h"
#include "event.h"

typedef int METRIC;	      /* defined by new_metric */
typedef short STAT;	      /* from EVENT_TO_INT(event_name) */

/* see stats.c for the definition of these stats */
extern struct dmcache_stats {
    /* Plain metrics */
    METRIC total;	      /* total execution time */
    METRIC tread;	      /* record read time, avg MSEC */
    METRIC tread_sd;	      /* record read time, std dev MSEC */
    METRIC twrite;	      /* record write time, avg  MSEC*/
    METRIC twrite_sd;	      /* record write time, std dev  MSEC*/
    METRIC permute;	      /* permutation time, avg MSEC */

    METRIC ThreadRequest;     /* ThreadRequest send time, avg TICS */
    METRIC ThreadRequesth;    /* ThreadRequest recv time, avg TICS */
    METRIC ThreadRequesth_sd; /* ThreadRequest recv time, stddev TICS */
    METRIC QueueRequest;      /* QueueRequest send time, avg TICS */
    METRIC QueueRequesth;     /* QueueRequest recv time, avg TICS */
    METRIC QueueRequesth_sd;  /* QueueRequest recv time, stddev TICS */
    METRIC InstantRequest;    /* InstantRequest send time, avg TICS */
    METRIC Reply;	      /* Reply send time, avg TICS */
    METRIC Replyh;	      /* Reply recv time, avg TICS */
    METRIC Replyh_sd;	      /* Reply recv time, stddev TICS */

    METRIC IOPread;	      /* IOPread time, avg MSEC */
    METRIC IOPread_sd;	      /* IOPread time, stddev MSEC */
    METRIC IOPwrite;	      /* IOPwrite time, avg MSEC */
    METRIC IOPwrite_sd;	      /* IOPwrite time, stddev MSEC */

    METRIC CPread_n;	      /* count of FSread calls */
    METRIC CPwrite_n;	      /* count of FSwrite calls */
    METRIC CPread_bytes;      /* bytes transferred by FSread calls */
    METRIC CPwrite_bytes;     /* bytes transferred by FSwrite calls */

    METRIC IOPread_n;	      /* count of IOP*read calls */
    METRIC IOPwrite_n;	      /* count of IOP*write calls */
    METRIC IOPread_bytes;     /* bytes transferred by IOP*read calls */
    METRIC IOPwrite_bytes;    /* bytes transferred by IOP*write calls */

    METRIC IOPputget;	      /* tics spent in memput/memget activity */

    METRIC EmptyBlock;	      /* avg tics to empty a block, in iopfs general */
    METRIC FillBlock;	      /* avg tics to fille a block, in iopfs general */

    METRIC Redirects;	      /* avg successful RedirectReply calls */

    METRIC messages;	      /* number of messages */
    METRIC messageBytes;      /* number of bytes of messages */

    METRIC LUtime;	      /* time for LU_decomposition */
    METRIC LUbytes;	      /* bytes moved for LU_decomposition */

    /* Array metrics */
    METRIC totalThruput;      /* total thruput in KBps */
    METRIC innerThruput;      /* thruput in KBps, per CP */
    METRIC outerThruput;      /* thruput in KBps, per CP */
    METRIC miss;	      /* cache misses, per proc */
    METRIC hit;		      /* cache hits, per proc */
    METRIC prefetch;	      /* cache prefetches, per proc */
    METRIC prefetchused;      /* cache prefetches used, per proc */
    METRIC diskmiss;	      /* disk-cache misses, per disk */
    METRIC diskhit;	      /* disk-cache hits, per disk */
    METRIC diskread;	      /* disk reads, per disk */
    METRIC diskwrite;	      /* disk writes, per disk */
    METRIC diskidle;	      /* disk idle time, per disk */
    METRIC diskwait;	      /* disk wait time, per disk, avg */
    METRIC diskwait_sd;	      /* disk wait time, per disk, std dev */
    METRIC diskmoves;	      /* disk movements, per disk */
    METRIC bustrans;	      /* IO bus transfers, per bus */
    METRIC buswait;	      /* bus wait time, per bus, total msec */

    METRIC diskqlength;	      /* average disk-queue length, per disk */
    METRIC diskqpasses;	      /* number of disk-queue passes, per disk */
    METRIC diskqempty;	      /* number of dequeues on empty diskq, per disk */
} stats;

extern void InitStats(void);	/* initialize the stats structure */

#endif /* STATS_H */
