/* @TITLE "worker.h: glue for Worker()"*/
/* 
 * This glues driver to Worker(), and Worker to IOPtop and CPtop.
 * functions:
 *   Worker
 *   Shutdown
 *   CPtop
 *   IOPtop
 *   IOWait
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: worker.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef WORKER_H
#define WORKER_H

extern void Worker(void);
extern void Shutdown(void);
extern void CPtop(int CPnum);
extern void IOPtop(int IOPnum);
extern void IOPend(int IOPnum);

/* Some more parameters shared by these three */
extern boolean FileIsNew;	/* set by driver, used by IOP */

#endif /* WORKER_H */
