#if !defined(CHANNEL_H)
#define CHANNEL_H

#include "socket.h"

class ToopsProcessor;

//-----------------------------------------------------------------------------
// ToopsChannelLink
// ============
// see to_list.h, tno_list.h
class ToopsChannelLink : public ToopsNamedObjectLink
{
public:
    ToopsChannelLink (ToopsChannel *c) : 
         ToopsNamedObjectLink((ToopsNamedObject*)c) {}
    virtual void write(int depth = 0, int mode = 0) const;
    ToopsChannel* object(void) { return (ToopsChannel*) _object();}
    //    ToopsChannelList* linkedTo(void) const	/ pt 9.94
    ToopsChannelList* linkedTo(void)
        { return (ToopsChannelList*) ToopsObjectLink::linkedTo(); }
    DECLARE_CLASSINFO(ToopsChannelLink); 
	
private:
    // prevent compiler from using copy / default constructor and assignment
    ToopsChannelLink(); 
    //ToopsChannelLink(const ToopsChannelLink&); //mjk 280895
    void operator=(const ToopsChannelLink&);

};

//-----------------------------------------------------------------------------
// ToopsChannel (source code -> channel.cpp/.C)
// ========================================
//
//class ToopsChannel : private ToopsNamedObject / pt 9.94
class ToopsChannel : public ToopsNamedObject
{
friend class ToopsSocket;  // accesses delay(), distort(), remember()
public:
    // states of a ToopsChannel
    // noConnection: 0 or 1 ToopsSockets connected, no communication possible
    // ready: 2 or more ToopsSockets connected, communication possible
    // destroy: at destruction.
    enum channelState { noConnection, ready, destroy};
    // the modes of a ToopsChannel are set automatically, when ToopsSockets connect
    // (at their construction) and disconnect(at their destruction):
    // - no mode: 1 or 0 ToopsSockets connected
    // - bidirectional: 2 ToopsSockets connected
    // - broadcast: 3 or more ToopsSockets connnected
    enum channelMode { noMode, bidirectional, broadcast };

    ///get a ToopsChannel's status and mode
    channelState status(void) const { return c_state; }
    channelMode mode(void) const { return c_mode; }

    // get a ToopsChannel by it's name
    inline static ToopsChannel* search(const char* n);
    // get an array of all ToopsChannels in the system. The array _must_ be
    // deleted after use. Size: numChannels().
    inline static ToopsChannel** systemChannels(void);

    // get the number of connected ToopsSockets
    instance_counter sockets(void) const { return c_connected.len(); }
    // get an array of all connected ToopsSockets. The array _must_ be deleted
    // after use. Size: sockets().
    inline ToopsSocket** mySockets(void);

    ToopsChannel(const char *name, responsibility r=user);
    ~ToopsChannel();

    virtual void write(int depth=0, int mode=0 ) const;
	
    DECLARE_CLASSINFO(ToopsChannel); 
    
protected:

    // This function is called before a ToopsMessage is sent. By implementing
    // this function in a derived class a variable delay time for the
    // ToopsChannel can be simulated.
    virtual simtime delay(ToopsMessage* msg, ToopsSocket* from, ToopsSocket* to)
        { return 0;}

    // This function is called before a ToopsMessage is sent. By implementing
    // this function in a derived class a channel specific distortion
    // behaviour can be simulated. Return 1, if the ToopsMessage shall
    // not arrive at all.
    virtual int distort(ToopsMessage* msg, ToopsSocket* from, ToopsSocket* to)
        { return 0;}

    // explained in toops.h
    virtual void atStart(void) {}
    virtual void atEnd(void) {}
    virtual void atStateChange(void) {}

private:
    channelState c_state;
    channelMode c_mode;

    ToopsSocketList c_connected;

    ToopsChannelLink sysLink; 

    static ToopsError fDestroyButSockets;

    void remember(ToopsSocketLink* toRemember);

};

//-----------------------------------------------------------------------------
// ToopsChannelList
// ============
// see timer.h, to_list.h, tno_list.h
class ToopsChannelList : public ToopsNamedObjectList
{
public:
    ToopsChannelList() : ToopsNamedObjectList() {}
    ~ToopsChannelList() {}
    void insert(ToopsChannelLink &r) { insert(&r); }
    void insert(ToopsChannelLink *p) { _insert((ToopsObjectLink*)p); }
    void append(ToopsChannelLink &r) { append(&r); }
    void append(ToopsChannelLink *p) { _append((ToopsObjectLink*)p); }
    void inserthere(ToopsChannelLink &r) { inserthere(&r); }
    void inserthere(ToopsChannelLink *p) { _inserthere((ToopsObjectLink*)p); }
    void appendhere(ToopsChannelLink &r) { appendhere(&r); }
    void appendhere(ToopsChannelLink *p) { _appendhere((ToopsObjectLink*)p); }
    ToopsChannel *current(void) { return (ToopsChannel*) _current(); }
    ToopsChannel *first(void) { return (ToopsChannel*) _first(); }
    ToopsChannel *last(void) { return (ToopsChannel*) _last(); }
    ToopsChannel *currentLink(void) { return (ToopsChannel*) _currentLink(); }
    ToopsChannel *firstLink(void) { return (ToopsChannel*) _firstLink(); }
    ToopsChannel *lastLink(void) { return (ToopsChannel*) _lastLink(); }
    
    
    int next(ToopsChannel*& rp)
    {
        if (_setnext())
            { rp = (ToopsChannel*) _current(); return 1; }
        else
            { rp = 0; return 0; }
    }
    int prev(ToopsChannel*& rp)
    {
        if (_setprev())
            { rp = (ToopsChannel*) _current(); return 1; }
        else
            { rp = 0; return 0; }
    }
    int getnext(ToopsChannel*& rp)
    {
        ToopsChannel * pptmp;
        if ((pptmp = (ToopsChannel*) _getnext()) != 0)
            { rp = pptmp; return 1; }
        else
            { rp = 0; return 0; }
    }
    int getprev(ToopsChannel*& rp)
    {
        ToopsChannel* pptmp;
        if ((pptmp = (ToopsChannel*) _getprev()) != 0)
            { rp = pptmp; return 1; }
        else
            { rp = 0; return 0; }
    }
    int next(ToopsChannelLink*& rpl)
    {
        if (_setnext())
           { rpl = (ToopsChannelLink*) _currentLink(); return 1; }
        else
            { rpl = 0; return 0; }
    }
    int prev(ToopsChannelLink*& rpl)
    {
        if (_setprev())
            { rpl = (ToopsChannelLink*) _currentLink(); return 1; }
        else
            { rpl = 0; return 0; }
    }
    int getnext(ToopsChannelLink*& rpl)
    {
        ToopsChannelLink * pptmp;
        if ((pptmp = (ToopsChannelLink*) _getnextlink()) != 0)
            { rpl = pptmp; return 1; }
        else
            { rpl = 0; return 0; }
    }
    int getprev(ToopsChannelLink*& rpl)
    {
        ToopsChannelLink* pptmp;
        if ((pptmp = (ToopsChannelLink*) _getprevlink()) != 0)
            { rpl = pptmp; return 1; }
        else
            { rpl = 0; return 0; }
    }
    
    void remove(ToopsChannelLink* t) { _remove((ToopsObjectLink*)t); }
    ToopsChannel* search(const char* n) { return (ToopsChannel*) _search(n); }
    ToopsChannel** touchAll(void) { return (ToopsChannel**) _touchAll(); }
    virtual void write(int depth = 0, int mode = 0) const;
    
    DECLARE_CLASSINFO(ToopsChannelList); 
    
private:
    // prevent compiler from using copy constructor and assignment
    //ToopsChannelList(const ToopsChannelList&); //mjk 280895
    void operator=(const ToopsChannelList&);

};

inline ToopsSocket** ToopsChannel::mySockets(void)
    { return c_connected.touchAll(); }

inline ToopsChannel* ToopsChannel::search(const char *n)
    { return channels()->search(n); }

inline ToopsChannel** ToopsChannel::systemChannels(void)
    { return channels()->touchAll(); }

#endif
