//--------------------------------------------------------------------------
//
//   context.h
//
//--------------------------------------------------------------------------
#if !defined(CONTEXT_H)
#define CONTEXT_H

#include <stddef.h>
#include "setjump.h"


//-----------------------------------------------------------------------------
// ToopsStackDir (source code -> context.cpp)
// ======================================
class ToopsStackDir
{
private:
    ToopsStackDir() {};
    static int dir;

public:
    // return a pointer to a local variable
    // beyond the current stack frame.
    static char *plusone();
    static char *plustwo();

    // TRUE if the stack grows up
	 static int grows_up()
	 {return dir;}

    // subtract two pointers as if the stack grew up.
    //   a - b = >0 if a>b
    //            0 if a==b
    //           <0 if a<b
	 static ptrdiff_t diff(void *a, void *b)
    {
		return grows_up() ?
	       ((char*)a - (char*)b) :
	       ((char*)b - (char*)a) ;
	 }

	 // Compare two pointers to check if the stack grew upwards
    static int less (void *a, void *b)      { return diff(a,b) < 0; }
    static int lesseq (void *a, void *b)    { return diff(a,b) <= 0; }
    static int greater (void *a, void *b)   { return diff(a,b) > 0; }
    static int greatereq (void *a,void *b)  { return diff(a,b) >= 0; }
};

//-----------------------------------------------------------------------------
// ToopsContext
// ========

class ToopsContext
{
friend class ToopsProcess;
friend class ToopsSimulation;
private:
	 char *SaveStack;
	 ptrdiff_t StackSize;
	 jmp_buf JB;
	 static char *StackBase;
	 ToopsContext()
	 {
		  SaveStack = 0;
		  StackSize = 0;
	 }
	 ~ToopsContext()  { delete[] SaveStack; }

};
#endif // if !defined(CONTEXT_H)
