
#if !defined(PROCUNIT_H)
#define PROCUNIT_H

#include "tno_list.h"
#include "tprocess.h"

class ToopsProcessor;
class ToopsProcess;
class ToopsProcessList;

//-----------------------------------------------------------------------------
// ToopsProcessorLink
// ==============
// see also ToopsNamedObjectLink (tno_list.h)
class ToopsProcessorLink : public ToopsNamedObjectLink
{
public:
    ToopsProcessorLink (ToopsProcessor *p) : 
         ToopsNamedObjectLink(( ToopsNamedObject*)p) {}
    virtual void write(int depth = 0, int mode = 0) const;
    ToopsProcessor* object(void) { return (ToopsProcessor*) _object();}

    DECLARE_CLASSINFO(ToopsProcessorLink); // pt 9.94    
    
private:
    // prevent compiler from using copy / default constructor and assignment
    ToopsProcessorLink();
    //ToopsProcessorLink(const ToopsProcessorLink&); //mjk 280895
    void operator=(const ToopsProcessorLink&);

};

//-----------------------------------------------------------------------------
// ToopsProcessorList (source code -> procunit.cpp/.C)
// ===============================================
// Class ToopsProcessorList forms a doubly linked list with a built in iterator.
// For explanations see ToopsTimerList (timer.h).
class ToopsProcessorList : public ToopsNamedObjectList
{
public:
    ToopsProcessorList() : ToopsNamedObjectList() {}
    ~ToopsProcessorList() {}
    void insert(ToopsProcessorLink &r) { insert(&r); }
    void insert(ToopsProcessorLink *p) { _insert((ToopsObjectLink*)p); }
    void append(ToopsProcessorLink &r) { append(&r); }
    void append(ToopsProcessorLink *p) { _append((ToopsObjectLink*)p); }
    void inserthere(ToopsProcessorLink &r) { inserthere(&r); }
    void inserthere(ToopsProcessorLink *p) { _inserthere((ToopsObjectLink*)p); }
    void appendhere(ToopsProcessorLink &r) { appendhere(&r); }
    void appendhere(ToopsProcessorLink *p) { _appendhere((ToopsObjectLink*)p); }
    ToopsProcessor *current(void) { return (ToopsProcessor*) _current(); }
    ToopsProcessor *first(void) { return (ToopsProcessor*) _first(); }
    ToopsProcessor *last(void) { return (ToopsProcessor*) _last(); }
    ToopsProcessor *currentLink(void) { return (ToopsProcessor*) _currentLink(); }
    ToopsProcessor *firstLink(void) { return (ToopsProcessor*) _firstLink(); }
    ToopsProcessor *lastLink(void) { return (ToopsProcessor*) _lastLink(); }

    int next(ToopsProcessor*& rp)
    {
        if (_setnext())
            { rp = (ToopsProcessor*) _current(); return 1; }
        else
            { rp = 0; return 0; }
    }
    int prev(ToopsProcessor*& rp)
    {
        if (_setprev())
            { rp = (ToopsProcessor*) _current(); return 1; }
        else
            { rp = 0; return 0; }
    }
    int getnext(ToopsProcessor*& rp)
    {
        ToopsProcessor * pptmp;
        if ((pptmp = (ToopsProcessor*) _getnext()) != 0)
            { rp = pptmp; return 1; }
        else
            { rp = 0; return 0; }
    }
    int getprev(ToopsProcessor*& rp)
    {
        ToopsProcessor* pptmp;
        if ((pptmp = (ToopsProcessor*) _getprev()) != 0)
            { rp = pptmp; return 1; }
        else
            { rp = 0; return 0; }
    }
    int next(ToopsProcessorLink*& rpl)
    {
        if (_setnext())
            { rpl = (ToopsProcessorLink*) _currentLink(); return 1; }
        else
            { rpl = 0; return 0; }
    }
    int prev(ToopsProcessorLink*& rpl)
    {
        if (_setprev())
            { rpl = (ToopsProcessorLink*) _currentLink(); return 1; }
        else
            { rpl = 0; return 0; }
    }
    int getnext(ToopsProcessorLink*& rpl)
    {
        ToopsProcessorLink * pptmp;
        if ((pptmp = (ToopsProcessorLink*) _getnextlink()) != 0)
            { rpl = pptmp; return 1; }
        else
            { rpl = 0; return 0; }
    }
    int getprev(ToopsProcessorLink*& rpl)
    {
        ToopsProcessorLink* pptmp;
        if ((pptmp = (ToopsProcessorLink*) _getprevlink()) != 0)
            { rpl = pptmp; return 1; }
        else
            { rpl = 0; return 0; }
    }
    
    void remove(ToopsProcessorLink* t) { _remove((ToopsObjectLink*)t); }
    ToopsProcessor* search(const char *name)
        { return (ToopsProcessor*) _search(name); }
    ToopsProcessor** touchAll(void)
        { return (ToopsProcessor**) _touchAll(); }
    void write(int depth = 0, int mode = 0) const;
    
    DECLARE_CLASSINFO(ToopsProcessorList); // pt 9.94
    
private:
    // prevent compiler from using copy / default constructor and assignment
    //ToopsProcessorList(const ToopsProcessorList&); //mjk 280895
    void operator=(const ToopsProcessorList&);

};

//-----------------------------------------------------------------------------
// ToopsProcessor (source code -> procunit.cpp/.C)
// ===========================================
//
//class ToopsProcessor : private ToopsNamedObject / pt 9.94
class ToopsProcessor : public ToopsNamedObject
{
friend class ToopsProcess;
public:
    ToopsProcessor(const char *name, simtime timeForContextSwitch = 0,
              responsibility r = user );
    ~ToopsProcessor();

    // ToopsProcessor's states are used internally to indicate whether a ToopsProcessor
    // must be activated. They do not represent real states.
    enum processorState { active, inactive };
    processorState status() const { return p_state; }

    // Returns ToopsProcessor's time for a context change.
    simtime timeToContextSwitch(void) const  { return p_timeToContextSwitch; }

    // Get a ToopsProcessor* by it's name. Returns 0, if not found.
    static ToopsProcessor* search(const char *n)
        { return processors()->search(n); }
    // Get an array of all ToopsProcessors in the simulation. The array _must_
    // be deleted by the user. Determine the length of the array with
    // numProcessors().
    static ToopsProcessor** systemProcessors(void)
        { return processors()->touchAll(); }

    // Returns the number of all ToopsProcesses on this ToopsProcessor.
    instance_counter processes(void)
        { return readyProcesses.len() + timedProcesses.len() +
                 unTimedProcesses.len(); }
    // Get an array with all ToopsProcesses on this ToopsProcessor. The array _must_ be
    // deleted by the user. Length of array obtainable via processes().
    ToopsProcess** myProcesses(void);

    static ToopsError wNoProcess;

/*    // re-export some information lost by the private inheritance:
    ToopsObject::isInheritedFrom;
    ToopsObject::DBGout;
    ToopsObject::isSameClass;
    ToopsNamedObject::name;
    ToopsSimulation::simstate;
    ToopsSimulation::state;
    ToopsSimulation::responsibility;
    ToopsSimulation::responsible;
    ToopsSimulation::stopReason;
    ToopsSimulation::time;
    ToopsSimulation::objects;
    ToopsSimulation::order;
    ToopsSimulation::stopSimulation;
    ToopsSimulation::stopWithError;
    ToopsSimulation::getTimeOut;
    ToopsSimulation::numProcessors;
    ToopsSimulation::numChannels;
    ToopsSimulation::numMessages;
    ToopsSimulation::numProcesses;
    ToopsSimulation::numTimers;
    ToopsSimulation::numSockets;*/	// pt 9.94

    // debugging stuff:
    virtual void write(int depth = 0, int mode = 0) const;
    enum dbgInfo { cstr=1, dstr=2, onActivate=4, onAtStart=8,
                   onRemember=16 };
    
    DECLARE_CLASSINFO(ToopsProcessor); // pt 9.94
    
protected:
    // explained in toops.h
    virtual void atEnd(void) {}

    // note: ToopsProcessor::atStart() is used internally, you may
    // use this function for your own purposes, but call
    // ToopsProcessor::atStart from your atStart() function. NEVER call
    // it from else where !!!!!!!!
    virtual void atStart(void);

    // note: since the ToopsProcessor's state are not real states, atStateChange()
    // is not called for a ToopsProcessor.
    // virtual void atStateChange(void) {}

    virtual void activate(void);    // don't use this at all

private:
    // Variables:
    simtime p_timeToContextSwitch;       // time needed for a context change
                                         // (relative sim. time)
    simtime p_timeOfContextSwitch;       // the time the last context change
                                         // took place (abs. sim. time)
    processorState p_state;              // ToopsProcessor's (not so real) state

    ToopsProcessorLink sysLink;              // Links to the system list
    ToopsProcessorLink toActivateLink;       // and to the list of ToopsProcessors
                                         // to be activated next.

    ToopsProcessList readyProcesses;         // ToopsProcesses, status ready/running
    ToopsProcessList timedProcesses;         // ToopsProcesses, status setWaiting
    ToopsProcessList unTimedProcesses;       // the remaining ToopsProcesses

    ToopsProcessLink *nextActivatedProcessLink;   // hook to the ToopsProcess to be
                                         // activated next.
    ToopsProcess* runningProcess;            // the actually running ToopsProcess

    static ToopsError fDestroy;

    // Methods:
    void remember(ToopsProcessLink* t);      // accessed by ToopsProcess

    // prevent compiler from using copy / default constructor and assignment
    //ToopsProcessor( ToopsProcessor& s); //mjk 280895
    ToopsProcessor();
    void operator=(const ToopsProcessor&);
};
#endif // #if !defined(PROCUNIT_H)
