#ifndef Entity_H
#define Entity_H
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   entity.h
class name      :   Entity
author          :   Andreas Rinkel

documentation   :   A protocol entity. The structure and behavior of this 
					  entity is a little more complex than that in the first
					  sample program "simpprot".
					  
					  The entity has a port manager that handles any incoming
					  messages on any port and expired timers (see class 
					  Manager in file manager.h) and passes them on to the
					  protocol (see class Protocol in file protocol.h). 

version         :   1.0
                    File is similar to "entity.h" in project simpprot,
                    except for pointers to Manager and Protocol in the
                    private member list of class Entity. The function 
                    behavior(), the constructors and the destructors 
                    (all in file entity.cpp) are different from simpprot, 
                    in that it calls the port manager. 
history         :   25.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/


// C++ standards

// TOOPS library
#include <tprocess.h>
#include <socket.h>
#include <procunit.h>
#include <channel.h>
#include <str.h>

// Project header
#include "synsoc.h"
#include "manager.h"
#include "protocol.h"


//------------------------------------------------------------------------
class Entity : public ToopsProcess
{
public:
    // Constructor 
    // * connects chan_service through a Synchron_Socket
    // * connects chan_partner through a ToopsSocket
    // * links a protocol and a manager to the sockets 
    Entity (  ToopsProcessor *cpu,
              ToopsChannel   *chan_service,
              ToopsChannel   *chan_partner,
              char           *name );

    // Destructor for normal clean-up work 
    // (deallocate the sockets, the manager and the protocol)
    ~Entity ();


protected:
    // The entities behavior is descibed in the file header above.
    virtual void behavior(void);

private:
    // pointers to the protocol and the port manager
    Manager         *_manager;
    Protocol        *_prot;

    // Sockets that connect the entity to chan_service and chan_partner
    Synchron_Socket *_user_access;
    ToopsSocket     *_peer_access;
};
#endif
