/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   sink.cpp
implementation
of class        :   Sink
author          :   Andreas Rinkel

version         :   1.0
                    File is identical to sink.cpp in project simpprot
                    except for function Sink::behavior().
history         :   23.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <iostream.h>

// TOOPS library

// Project header
#include "sink.h"   


//------------------------------------------------------------------------
Sink :: Sink (ToopsProcessor *cpu, ToopsChannel *chan, char *name)
	    : ToopsProcess(cpu, 1, name)
{
    String    _text;

    // connect to chan through a synchronous socket
    _text   = name;
    _text  += "_socket";
    _socket = new Synchron_Socket (_text, this, chan);
}

//------------------------------------------------------------------------
Sink:: ~Sink()
{ 
    delete _socket;
}

//------------------------------------------------------------------------
void Sink:: behavior (void) 
{  
	// Service Primitive DataInd 
    DataInd          *_data_ind;

    // listen for new messages (i.e. DataInd service primitives)
	// print info to cout and delete the received service primitive
    while (1)
    {
		_data_ind = (DataInd*) _socket->receive();
        cout << ToopsSimulation::time() << " "
			  << name() << ": message \"" << _data_ind->getText() 
             << "\" received." << endl;
        delete _data_ind;
    }
}

