/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   source.cpp
implementation
of class        :   Source
author          :   Andreas Rinkel

version         :   1.0
                    File is identical to source.cpp in project simpprot
                    except for function Sink::behavior().
                    
history         :   24.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <iostream.h>

// TOOPS library

// Project header
#include "source.h"   


//------------------------------------------------------------------------
Source  :: Source (ToopsProcessor *cpu, ToopsChannel *chan, char *name)
	    : ToopsProcess(cpu, 1, name)
{
    String    _text;

    // Definition of the member objects
    _text   = name;
    _text  += "_socket";
    _socket = new Synchron_Socket (_text, this, chan);
}

//------------------------------------------------------------------------
Source:: ~Source()
{ 
    delete _socket;
}

//------------------------------------------------------------------------
void 
Source:: behavior (void) 
{ 
	// The source uses DataReq service primitives to pass information
	// to chan.	
    DataReq    *_data_req;
    
    // Content of the message
    String     st = "Hello";
    
	// Forever
    while (1)
    {
		 // generate a data request to be passed on
		 _data_req = new DataReq( st, time() );
        
        // Print information to cout 
        cout << ToopsSimulation::time() << " " << name() 
			  << ": passing a new message to SAP. " << endl;

        // pass service primitive over syncronous channel (service access point)
        // to the service provider
        _socket->send ( _data_req );  
        
        delete _data_req;
        
		// sleep for some time after successfully passing on the service primitive
        consumeTime(5);
    }
}

