#ifndef Source_H
#define Source_H
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   source.h
class name      :   Source
author          :   Andreas Rinkel

documentation   :   Source is a service user connected to the service access
                    point through a synchronous channel. It periodically tries 
                    to send service primitives.
                    
                    An overflow of the service provider with primitives
                    is avoided by the synchronous channel even if the
                    processing time for the service primitive by
                    the services provider is longer than the requested
                    time between two service primitives ("blocking send").

                    You may make some experiments by setting different time
                    values. 

                    Header file identical to "source.h" in project simpprot,
                    although the implementation of function behavior() 
                    is different.
                    
version         :   1.0
history         :   23.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/


// C++ standards

// TOOPS library
#include <tprocess.h>
#include <procunit.h>
#include <channel.h>
#include <str.h>

// Project header
#include "synsoc.h"
#include "sdu.h"


//------------------------------------------------------------------------
class Source : public ToopsProcess
{

public:
    // constructor sets up the connection to chan through a 
    // synchronous socket
    Source (ToopsProcessor *cpu, ToopsChannel *chan, char *name);
    // destructor deletes the socket
    ~ Source ();

protected:
    // behavior: periodically passes DataReq service primitives 
    //           (i.e. messages) to chan
    virtual void behavior(void);


private:
    // synchronous socket 
    Synchron_Socket *_socket;

};
#endif
