#ifndef Entity_H
#define Entity_H
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   entity.h
class name      :   Entity
author          :   Andreas Rinkel

documentation   :   Entity is the class that describes the protocol
                    entities on the source and on the sink end. It is
                    connected to the service user through the channel
                    "chan_service" and to a peer entity through 
                    "chan_partner". These two channels are parameters of
                    the constructor and will be connected through a
                    Synchron_Socket (chan_service) and a ToopsSocket
                    (chan_partner).
                                        
                    The entity only waits for messages arriving from the
                    SAP or from the peer entity. It writes a short notice
                    to <stdout>, waits 4 time units (time for protocol 
                    processing) and passes the same message on. 
                    
                    You may take a closer look at the behavior by:
                    * modifying the time values
                    * examining the synchronous communication between the SAP
                      and the entity (e.g., drawing a Message Sequence Chart)
                    * examining how the behavior changes, if consumeTime is
                      called at different points  

version         :   1.0
history         :   23.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/


// C++ standards
#include <strstrea.h>

// TOOPS library
#include <tprocess.h>
#include <socket.h>
#include <procunit.h>
#include <channel.h>
#include <str.h>

// Project header
#include "synsoc.h"

//------------------------------------------------------------------------
class Entity : public ToopsProcess
{
public:
    // Constructor 
    // * connects chan_service through a Synchron_Socket
    // * connects chan_partner through a ToopsSocket
    Entity (  ToopsProcessor *cpu,
              ToopsChannel   *chan_service,
              ToopsChannel   *chan_partner,
              char           *name );

    // Destructor for normal clean-up work (deallocate the sockets)
    ~Entity ();


protected:
    // The entities behavior is descibed in the file header above.
    virtual void behavior(void);

private:
    // Sockets that connect the entity to chan_service and chan_partner
    Synchron_Socket *_service_access;
    ToopsSocket     *_peer_entity_access;
};
#endif
