#ifndef  Msg_H
#define  Msg_H
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   msg.h
class name      :   TextMessage
author          :   Andreas Rinkel

documentation   :   Simple message derived from ToopsMessage, just
                    containing a String.

version         :   1.0, 09.09.94
history         :   19.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/



// TOOPS library
#include <message.h>


// Class Description  ----------------------------------------------------
class  TextMessage : public ToopsMessage
{
public:
    // contructor that allocates memory for the string and stores the
    // content in _str.
    TextMessage(const char *messageContent) 
        : ToopsMessage() 
    { 
        int messageLength = strlen(messageContent) + 1;
        _str = new char[messageLength];
        strcpy(_str, messageContent);
    }

    // destructor
    // Does the clean-up work.
    ~TextMessage () { delete _str; };

    // duplicate the message
    // This virtual method is automatically called by the socket.
    // It always has to return a message that is newly allocated
    // from the heap (i.e. allocated with "new") and identical to
    // the original message.
    // duplicate must be implemeted by the application programmer.
    virtual ToopsMessage  *duplicate(void)
            {  return new TextMessage (_str);}

    // get content of the message
    // Important: The return value is only a pointer to
    //            the internal String.              
    char * getText() { return _str; };

private:
    // content of the message: 
    char *  _str;       

};
#endif
