/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   sink.cpp
implementation
of class        :   Sink
author          :   Andreas Rinkel

version         :   1.0
history         :   23.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/

// C++ standards
#include <strstrea.h>

// TOOPS library

// Project header
#include "sink.h"   


//------------------------------------------------------------------------
Sink :: Sink (ToopsProcessor *cpu, ToopsChannel *chan, char *name)
	    : ToopsProcess(cpu, 1, name)
{
    String    _text;

    // connect to chan through a synchronous socket
    _text   = name;
    _text  += "_socket";
    _socket = new Synchron_Socket (_text, this, chan);
}

//------------------------------------------------------------------------
Sink:: ~Sink()
{ 
    delete _socket;
}

//------------------------------------------------------------------------
void Sink:: behavior (void) 
{  
    TextMessage     *_msg;

    // listen for new messages
    while (1)
    {
        _msg = (TextMessage*) _socket->receive();
        cout << name() << ": message \"" << _msg->getText() 
             << "\" received at: " << time() << endl;
        delete _msg;
    }
}

