#ifndef Sink_H
#define Sink_H
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
file name       :   sink.h
class name      :   Sink
author          :   Andreas Rinkel

documentation   :   Sink is a simple data sink, it only receives messages.

version         :   1.0
history         :   23.04.96  Manfred Kraess
                    clean-up and modification
--------------------------------------------------------------------------*/


// C++ standards
#include <strstrea.h>

// TOOPS library
#include <tprocess.h>
#include <procunit.h>  
#include <channel.h>   
#include <str.h>

// Project header
#include "synsoc.h"
#include "msg.h"

//------------------------------------------------------------------------
class Sink : public ToopsProcess
{

public:
    // constructor set up the connection to chan through a 
    // synchronous socket
    Sink (ToopsProcessor *cpu, ToopsChannel *chan, char *name);

    // destructor deletes the socket
    ~Sink ();

protected:
    // behavior: listen for new messages and print to <stdout>
    virtual void behavior(void);

private:
    // synchronous socket 
    Synchron_Socket *_socket;

};
#endif
